/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbtools.schema.ForeignKey;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dbtools.schema.SchemaViewField;

public class HSQLDBRenderer
extends SchemaRenderer {
    public static final String RENDERER_NAME = "hsqldb";

    public HSQLDBRenderer() {
        this.setDbVendorName(RENDERER_NAME);
    }

    public HSQLDBRenderer(PrintStream ps) {
        super(ps);
        this.setDbVendorName(RENDERER_NAME);
    }

    @Override
    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using HSQLDB renderer ...", true);
        StringBuilder schema = new StringBuilder();
        ArrayList<ForeignKey> foreignKeysToCreate = new ArrayList<ForeignKey>();
        ArrayList<SchemaField> uniqueFields = null;
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(true, true, schema, requestedTables, requestedViews);
        }
        for (SchemaTable table : requestedTables) {
            ArrayList<SchemaField> indexFields = new ArrayList<SchemaField>();
            uniqueFields = new ArrayList<SchemaField>();
            String tableType = table.getParameter("tableType");
            if (tableType == null || tableType.equals("")) {
                tableType = "CACHED";
            }
            schema.append("CREATE ").append(tableType).append(" TABLE ");
            schema.append(table.getName());
            schema.append(" (\n");
            List<SchemaField> fields = table.getFields();
            SchemaField enumPKField = null;
            SchemaField enumValueField = null;
            for (int j = 0; j < fields.size(); ++j) {
                String defaultValue;
                SchemaField field = fields.get(j);
                schema.append("\t");
                schema.append(field.getName());
                schema.append(" ");
                schema.append(this.getTypes().get(field.getJdbcType()));
                if (field.getSize() > 0) {
                    schema.append("(");
                    schema.append(field.getSize());
                    schema.append(")");
                }
                if ((defaultValue = field.getDefaultValue()) != null && !defaultValue.equals("")) {
                    schema.append(" DEFAULT ").append(this.formatDefaultValue(field));
                }
                if (field.isNotNull() && !field.isIncrement()) {
                    schema.append(" NOT NULL");
                }
                if (field.isIncrement()) {
                    schema.append(" GENERATED BY DEFAULT AS IDENTITY (START WITH ").append(field.getIncrementInitialValue()).append(")");
                }
                if (field.isPrimaryKey()) {
                    schema.append(" PRIMARY KEY");
                }
                if (field.isUnique()) {
                    uniqueFields.add(field);
                }
                if (field.isIndex()) {
                    indexFields.add(field);
                }
                if (!field.getForeignKeyField().equals("")) {
                    foreignKeysToCreate.add(new ForeignKey(table.getName(), field.getName(), field.getForeignKeyTable(), field.getForeignKeyField()));
                }
                schema.append("");
                if (j == fields.size() - 1) {
                    if (uniqueFields.size() > 0) {
                        schema.append(",\n\tUNIQUE(");
                        for (int k = 0; k < uniqueFields.size(); ++k) {
                            SchemaField uField = (SchemaField)uniqueFields.get(k);
                            if (k != 0) {
                                schema.append(", ");
                            }
                            schema.append(uField.getName());
                        }
                        schema.append(")");
                    }
                } else {
                    schema.append(",\n");
                }
                if (enumPKField == null && field.isPrimaryKey()) {
                    enumPKField = field;
                }
                if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
                enumValueField = field;
            }
            List<List<String>> uniqueDeclarations = table.getUniqueDeclarations();
            for (List<String> uniqueDeclaration : uniqueDeclarations) {
                String uniqueFieldString = "";
                List<String> uniqueFieldsCombo = uniqueDeclaration;
                for (int k = 0; k < uniqueFieldsCombo.size(); ++k) {
                    String uniqueField = uniqueFieldsCombo.get(k);
                    if (k > 0) {
                        uniqueFieldString = uniqueFieldString + ", ";
                    }
                    uniqueFieldString = uniqueFieldString + uniqueField;
                }
                schema.append(",\n\tUNIQUE(").append(uniqueFieldString).append(")");
            }
            schema.append("\n);");
            for (SchemaField indexField : indexFields) {
                schema.append("\nCREATE INDEX ").append(table.getName()).append(indexField.getName()).append("_IDX ON ").append(table.getName()).append(" (").append(indexField.getName()).append(");");
            }
            schema.append("\n\n");
            HSQLDBRenderer.generateEnumSchema(schema, table, this.getAlreadyCreatedEnum(), enumPKField, enumValueField, createInserts);
        }
        for (ForeignKey fk : foreignKeysToCreate) {
            schema.append("ALTER TABLE ").append(fk.getPrimaryKeyTable()).append("\n");
            schema.append("ADD CONSTRAINT ").append(fk.getPrimaryKeyTable()).append("_").append(fk.getPrimaryKeyField()).append("_FK\n");
            schema.append("FOREIGN KEY (").append(fk.getPrimaryKeyField()).append(")\n");
            schema.append("REFERENCES ").append(fk.getForeignKeyTable()).append(" (").append(fk.getForeignKeyField()).append(");\n");
            schema.append("\n");
        }
        for (SchemaView view : requestedViews) {
            schema.append("CREATE VIEW ").append(view.getName()).append(" AS \n");
            schema.append("  SELECT \n");
            Iterator<SchemaViewField> vfItr = view.getViewFields().iterator();
            while (vfItr.hasNext()) {
                SchemaViewField viewField = vfItr.next();
                schema.append("\t").append(viewField.getExpression()).append(" ").append(viewField.getName());
                if (vfItr.hasNext()) {
                    schema.append(",\n");
                    continue;
                }
                schema.append("\n");
            }
            schema.append("  ").append(view.getViewPostSelectClause()).append(";");
            schema.append("\n\n");
        }
        return schema.toString();
    }

    @Override
    public String formatDefaultValue(SchemaField field) {
        String defaultValue = field.getDefaultValue();
        String newDefaultValue = "";
        Class<?> javaType = field.getJavaClassType();
        newDefaultValue = javaType == Boolean.TYPE ? (defaultValue.toUpperCase().equals("TRUE") || defaultValue.equals("1") ? "'true'" : "'false'") : super.formatDefaultValue(field);
        return newDefaultValue;
    }
}

