/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dbtools.schema.ForeignKey;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;

public class MySQLRenderer
extends SchemaRenderer {
    public static final String RENDERER_NAME = "mysql";

    public MySQLRenderer() {
        this.setDbVendorName(RENDERER_NAME);
    }

    public MySQLRenderer(PrintStream ps) {
        super(ps);
        this.setDbVendorName(RENDERER_NAME);
    }

    @Override
    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using MySQL renderer ...", true);
        StringBuilder schema = new StringBuilder();
        ArrayList<ForeignKey> foreignKeysToCreate = new ArrayList<ForeignKey>();
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(true, false, schema, requestedTables, requestedViews);
        }
        for (SchemaTable table : requestedTables) {
            SchemaField primaryKey = null;
            ArrayList<SchemaField> indexFields = new ArrayList<SchemaField>();
            schema.append("CREATE TABLE ");
            schema.append(table.getName());
            schema.append(" (\n");
            List<SchemaField> fields = table.getFields();
            SchemaField enumPKField = null;
            SchemaField enumValueField = null;
            int incrementFieldInitialValue = 1;
            for (int j = 0; j < fields.size(); ++j) {
                String defaultValueFormatted;
                String defaultValue;
                SchemaField field = fields.get(j);
                if (field.isPrimaryKey()) {
                    primaryKey = field;
                }
                schema.append("\t");
                schema.append(field.getName());
                schema.append(" ");
                schema.append(this.getTypes().get(field.getJdbcType()));
                if (field.getSize() > 0) {
                    int digits = field.getSize() + field.getDecimals();
                    schema.append("(");
                    schema.append(digits);
                    if (field.getDecimals() > 0) {
                        schema.append(", ").append(field.getDecimals());
                    }
                    schema.append(")");
                }
                if (field.isNotNull()) {
                    schema.append(" NOT NULL");
                }
                if (field.isIncrement()) {
                    incrementFieldInitialValue = field.getIncrementInitialValue();
                    if (!table.isEnumerationTable()) {
                        schema.append(" AUTO_INCREMENT");
                    }
                }
                if ((defaultValue = field.getDefaultValue()) != null && !defaultValue.equals("") && (defaultValueFormatted = this.formatDefaultValue(field)).length() > 0) {
                    schema.append(" DEFAULT ").append(defaultValueFormatted);
                }
                if (field.isUnique()) {
                    schema.append(" UNIQUE");
                }
                if (field.isIndex()) {
                    indexFields.add(field);
                }
                if (!field.getForeignKeyField().equals("")) {
                    foreignKeysToCreate.add(new ForeignKey(table.getName(), field.getName(), field.getForeignKeyTable(), field.getForeignKeyField()));
                }
                schema.append("");
                if (j == fields.size() - 1) {
                    if (primaryKey != null) {
                        schema.append(",\n");
                        schema.append("\tPRIMARY KEY(");
                        schema.append(primaryKey.getName());
                        schema.append(")");
                    }
                    for (SchemaField indexField : indexFields) {
                        schema.append(",\n\tINDEX ").append(indexField.getName()).append("_IDX (").append(indexField.getName()).append(")");
                    }
                } else {
                    schema.append(",\n");
                }
                if (enumPKField == null && field.isPrimaryKey()) {
                    enumPKField = field;
                }
                if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
                enumValueField = field;
            }
            List<List<String>> uniqueDeclarations = table.getUniqueDeclarations();
            for (List<String> uniqueDeclaration : uniqueDeclarations) {
                String uniqueFieldString = "";
                ArrayList uniqueFields = (ArrayList)uniqueDeclaration;
                for (int k = 0; k < uniqueFields.size(); ++k) {
                    String uniqueField = (String)uniqueFields.get(k);
                    if (k > 0) {
                        uniqueFieldString = uniqueFieldString + ", ";
                    }
                    uniqueFieldString = uniqueFieldString + uniqueField;
                }
                schema.append(",\n\tUNIQUE(").append(uniqueFieldString).append(")");
            }
            String tableType = table.getParameter("tableType");
            if (tableType != null && !tableType.equals("")) {
                schema.append("\n) TYPE=");
                schema.append(tableType);
                schema.append(";\n\n");
            } else {
                schema.append("\n);\n\n");
            }
            if (!table.isEnumerationTable() && incrementFieldInitialValue > 1) {
                schema.append("\nALTER TABLE ").append(table.getName()).append(" AUTO_INCREMENT = ").append(incrementFieldInitialValue).append(";\n\n");
            }
            MySQLRenderer.generateEnumSchema(schema, table, this.getAlreadyCreatedEnum(), enumPKField, enumValueField, createInserts);
        }
        for (ForeignKey fk : foreignKeysToCreate) {
            schema.append("ALTER TABLE ").append(fk.getPrimaryKeyTable()).append("\n");
            schema.append("ADD CONSTRAINT ").append(fk.getPrimaryKeyTable()).append("_").append(fk.getPrimaryKeyField()).append("_FK\n");
            schema.append("FOREIGN KEY (").append(fk.getPrimaryKeyField()).append(")\n");
            schema.append("REFERENCES ").append(fk.getForeignKeyTable()).append(" (").append(fk.getForeignKeyField()).append(");\n");
            schema.append("\n");
        }
        return schema.toString();
    }

    @Override
    public String formatDefaultValue(SchemaField field) {
        String defaultValue = field.getDefaultValue();
        String newDefaultValue = "";
        Class<?> javaType = field.getJavaClassType();
        if (javaType == Date.class) {
            if (defaultValue.equalsIgnoreCase("now")) {
                newDefaultValue = "";
                System.out.println("WARNING: MySQL does NOT support now or now() as a default for date fields... skipping DEFAULT");
            }
        } else {
            newDefaultValue = super.formatDefaultValue(field);
        }
        return newDefaultValue;
    }
}

