/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbtools.schema.ForeignKey;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dbtools.schema.SchemaViewField;

public class PostgreSQLRenderer
extends SchemaRenderer {
    public static final String RENDERER_NAME = "postgresql";
    private static final String NOW = "CURRENT_TIMESTAMP";

    public PostgreSQLRenderer() {
        this.setDbVendorName(RENDERER_NAME);
    }

    public PostgreSQLRenderer(PrintStream ps) {
        super(ps);
        this.setDbVendorName(RENDERER_NAME);
    }

    @Override
    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using PostgreSQL renderer ...", true);
        StringBuilder schema = new StringBuilder();
        ArrayList<ForeignKey> foreignKeysToCreate = new ArrayList<ForeignKey>();
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(false, true, schema, requestedTables, requestedViews);
        }
        Iterator<Object> i$ = requestedTables.iterator();
        while (i$.hasNext()) {
            SchemaTable requestedTable;
            SchemaTable table = requestedTable = i$.next();
            List<SchemaField> fields = table.getFields();
            String sequencerName = null;
            int sequencerStartValue = 1;
            for (SchemaField field : fields) {
                String fieldSeqName = field.getSequencerName();
                if (fieldSeqName == null || fieldSeqName.length() <= 0) continue;
                sequencerName = fieldSeqName;
                sequencerStartValue = field.getSequencerStartValue();
                break;
            }
            SchemaField primaryKey = null;
            ArrayList<SchemaField> indexFields = new ArrayList<SchemaField>();
            schema.append("CREATE TABLE ");
            schema.append(table.getName());
            schema.append(" (\n");
            SchemaField enumPKField = null;
            SchemaField enumValueField = null;
            for (int j = 0; j < fields.size(); ++j) {
                String defaultValue;
                SchemaField field = fields.get(j);
                if (field.isPrimaryKey()) {
                    primaryKey = field;
                }
                schema.append("\t");
                schema.append(field.getName());
                schema.append(" ");
                schema.append(this.getTypes().get(field.getJdbcType()));
                if (field.getSize() > 0) {
                    schema.append("(");
                    schema.append(field.getSize());
                    if (field.getDecimals() > 0) {
                        schema.append(", ").append(field.getDecimals());
                    }
                    schema.append(")");
                }
                if ((defaultValue = field.getDefaultValue()) != null && !defaultValue.equals("")) {
                    String newDefaultValue = this.formatDefaultValue(field);
                    if (newDefaultValue.toUpperCase().equals("'NOW'")) {
                        newDefaultValue = NOW;
                    }
                    schema.append(" DEFAULT ").append(this.formatDefaultValue(field));
                } else if (field.isNotNull()) {
                    schema.append(" NOT NULL");
                }
                if (field.isUnique()) {
                    schema.append(" UNIQUE");
                }
                if (field.isIndex()) {
                    indexFields.add(field);
                }
                if (!field.getForeignKeyField().equals("")) {
                    foreignKeysToCreate.add(new ForeignKey(table.getName(), field.getName(), field.getForeignKeyTable(), field.getForeignKeyField()));
                }
                schema.append("");
                if (j == fields.size() - 1) {
                    if (primaryKey != null) {
                        schema.append(",\n");
                        schema.append("\tPRIMARY KEY(");
                        schema.append(primaryKey.getName());
                        schema.append(")");
                    }
                } else {
                    schema.append(",\n");
                }
                if (enumPKField == null && field.isPrimaryKey()) {
                    enumPKField = field;
                }
                if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
                enumValueField = field;
            }
            List<List<String>> uniqueDeclarations = table.getUniqueDeclarations();
            for (List<String> uniqueDeclaration : uniqueDeclarations) {
                String uniqueFieldString = "";
                for (int k = 0; k < uniqueDeclaration.size(); ++k) {
                    String uniqueField = uniqueDeclaration.get(k);
                    if (k > 0) {
                        uniqueFieldString = uniqueFieldString + ", ";
                    }
                    uniqueFieldString = uniqueFieldString + uniqueField;
                }
                schema.append(",\n\tUNIQUE(").append(uniqueFieldString).append(")");
            }
            schema.append("\n);");
            for (SchemaField indexField : indexFields) {
                schema.append("\nCREATE INDEX ").append(table.getName()).append(indexField.getName()).append("_IDX ON ").append(table.getName()).append(" (").append(indexField.getName()).append(");");
            }
            schema.append("\n");
            PostgreSQLRenderer.generateEnumSchema(schema, table, this.getAlreadyCreatedEnum(), enumPKField, enumValueField, createInserts);
            if (sequencerName != null && sequencerName.length() > 0) {
                if (table.isEnumerationTable() && super.isCreateEnumInserts()) {
                    schema.append("CREATE SEQUENCE ").append(sequencerName).append(" START WITH ").append(table.getEnumerations().size()).append(";\n");
                } else {
                    schema.append("CREATE SEQUENCE ").append(sequencerName).append(" START WITH ").append(sequencerStartValue).append(";\n");
                }
            }
            schema.append("\n\n");
        }
        for (ForeignKey fk : foreignKeysToCreate) {
            schema.append("ALTER TABLE ").append(fk.getPrimaryKeyTable()).append("\n");
            schema.append("ADD CONSTRAINT ").append(fk.getPrimaryKeyTable()).append("_").append(fk.getPrimaryKeyField()).append("_FK\n");
            schema.append("FOREIGN KEY (").append(fk.getPrimaryKeyField()).append(")\n");
            schema.append("REFERENCES ").append(fk.getForeignKeyTable()).append(" (").append(fk.getForeignKeyField()).append(");\n");
            schema.append("\n");
        }
        for (SchemaView view : requestedViews) {
            schema.append("CREATE VIEW ").append(view.getName()).append(" AS \n");
            String aliases = "";
            String selectItems = "";
            Iterator<SchemaViewField> vfItr = view.getViewFields().iterator();
            while (vfItr.hasNext()) {
                SchemaViewField viewField = vfItr.next();
                aliases = aliases + viewField.getName();
                selectItems = selectItems + "\t" + viewField.getExpression();
                if (vfItr.hasNext()) {
                    aliases = aliases + ", ";
                    selectItems = selectItems + ",\n";
                    continue;
                }
                selectItems = selectItems + "\n";
            }
            schema.append("(").append(aliases).append(")");
            schema.append(" AS\n  SELECT \n").append(selectItems);
            schema.append("  ").append(view.getViewPostSelectClause()).append(";");
            schema.append("\n\n");
        }
        return schema.toString();
    }

    @Override
    public String generatePostSchema(SchemaDatabase database, String[] tablesToGenerate) {
        this.showProgress("Generating Post SQL schema using PostgreSQL renderer ...", true);
        StringBuilder postSchema = new StringBuilder();
        postSchema.append("\n\n");
        for (SchemaTable table : this.getTablesToGenerate(database, tablesToGenerate)) {
            for (SchemaField field : table.getFields()) {
                String sequencerName = field.getSequencerName();
                int sequencerStartValue = field.getSequencerStartValue();
                if (sequencerName == null || sequencerName.length() <= 0) continue;
                if (sequencerStartValue == 1) {
                    postSchema.append("SELECT SETVAL ('").append(sequencerName).append("', (SELECT MAX(").append(field.getName()).append(")+1 FROM ").append(table.getName()).append("), false);\n\n");
                    continue;
                }
                postSchema.append("SELECT SETVAL ('").append(sequencerName).append("', ").append(sequencerStartValue).append(", false);\n\n");
            }
        }
        return postSchema.toString();
    }

    @Override
    public void generateDropSchema(boolean addIfExists, boolean ifExistsAtEndOfStmnt, StringBuilder schema, List<SchemaTable> tablesToGenerate, List<SchemaView> viewsToGenerate) {
        for (SchemaTable table : tablesToGenerate) {
            for (SchemaField field : table.getFields()) {
                String sequencerName = field.getSequencerName();
                if (sequencerName == null || sequencerName.length() <= 0) continue;
                schema.append("DROP SEQUENCE ").append(sequencerName).append(";\n");
            }
        }
        super.generateDropSchema(false, true, schema, tablesToGenerate, viewsToGenerate);
    }
}

