/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.util.StringTokenizer;

public class SQLStatement {
    private String statement;
    private StringTokenizer t;
    private SQLType type = SQLType.UNKNOWN;
    private String table;

    public SQLStatement(String statement) {
        this.statement = statement;
        this.initialAnalyze();
    }

    private void initialAnalyze() {
        this.t = new StringTokenizer(this.statement, " ", false);
        while (this.t.hasMoreTokens()) {
            String token = this.t.nextToken().toUpperCase();
            if (token.equals("SELECT")) {
                this.parseSelect();
                continue;
            }
            if (token.equals("INSERT")) {
                this.parseInsert();
                continue;
            }
            if (token.equals("UPDATE")) {
                this.parseUpdate();
                continue;
            }
            if (!token.equals("DELETE")) continue;
            this.parseDelete();
        }
    }

    private void parseSelect() {
        while (this.t.hasMoreTokens()) {
            if (!this.t.nextToken().equalsIgnoreCase("FROM")) continue;
            this.table = this.t.nextToken();
            this.type = SQLType.SELECT;
            break;
        }
    }

    private void parseInsert() {
        if (this.t.nextToken().equalsIgnoreCase("INTO")) {
            this.type = SQLType.INSERT;
            this.table = this.t.nextToken();
        }
    }

    private void parseUpdate() {
        this.type = SQLType.UPDATE;
        this.table = this.t.nextToken();
    }

    private void parseDelete() {
        while (this.t.hasMoreTokens()) {
            if (!this.t.nextToken().equalsIgnoreCase("FROM")) continue;
            this.table = this.t.nextToken();
            this.type = SQLType.DELETE;
            break;
        }
    }

    public SQLType getType() {
        return this.type;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isSelect() {
        return this.type == SQLType.SELECT;
    }

    public boolean isInsert() {
        return this.type == SQLType.INSERT;
    }

    public boolean isUpdate() {
        return this.type == SQLType.UPDATE;
    }

    public boolean isDelete() {
        return this.type == SQLType.DELETE;
    }

    public static enum SQLType {
        UNKNOWN,
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        ALTER;

    }
}

