/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dbtools.schema.ClassInfo;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dom4j.Element;

public class SchemaDatabase {
    private String name;
    private List<SchemaTable> tables = new ArrayList<SchemaTable>();
    private Map<String, SchemaTable> tablesByName = new TreeMap<String, SchemaTable>();
    private List<SchemaView> views = new ArrayList<SchemaView>();
    private Map<String, SchemaView> viewsByName = new TreeMap<String, SchemaView>();
    private Map<String, String> tableClassNames = new HashMap<String, String>();
    private List<String> postSQLScriptFiles = null;
    private Set<String> sequenceNameSet = new HashSet<String>();

    public SchemaDatabase(String schemaFilename, String dbVendorName, boolean schemaXMLFilenameIsAResource, Element dbElement) {
        this.name = dbElement.attribute("name").getValue();
        Iterator tablesItr = dbElement.elementIterator("table");
        this.removeAllTables();
        while (tablesItr.hasNext()) {
            Element tableElement = (Element)tablesItr.next();
            this.addTable(dbVendorName, tableElement);
        }
        Iterator viewsItr = dbElement.elementIterator("view");
        this.removeAllViews();
        while (viewsItr.hasNext()) {
            Element viewElement = (Element)viewsItr.next();
            this.addView(viewElement);
        }
        this.postSQLScriptFiles = new ArrayList<String>();
        for (Element postSQLScriptElement : dbElement.elements("postSQLScriptFile")) {
            String insertsPathname = postSQLScriptElement.attribute("pathname").getValue();
            boolean relativePath = true;
            try {
                relativePath = Boolean.parseBoolean(postSQLScriptElement.attribute("relativePath").getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            insertsPathname = this.prepareFilepath(schemaFilename, insertsPathname, schemaXMLFilenameIsAResource, relativePath);
            this.postSQLScriptFiles.add(insertsPathname);
        }
    }

    public Element toXML(Element parent) {
        Element element = parent.addElement("database");
        element.addAttribute("name", this.name);
        for (SchemaTable table : this.getTables()) {
            table.toXML(element);
        }
        return element;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean addTable(String dbVendorName, Element tableElement) {
        String seqName;
        SchemaTable table = new SchemaTable(dbVendorName, tableElement);
        this.duplicateTableViewCheck(table.getName());
        SchemaField primaryKey = table.getPrimaryKey();
        if (primaryKey != null && (seqName = primaryKey.getSequencerName()) != null && seqName.length() > 0) {
            if (!this.sequenceNameSet.contains(seqName)) {
                this.sequenceNameSet.add(seqName);
            } else {
                throw new IllegalStateException("Sequence [" + seqName + "] from table [" + table.getName() + "] ALREADY exists!");
            }
        }
        this.tables.add(table);
        this.tablesByName.put(table.getName(), table);
        this.tableClassNames.put(table.getName(), table.getClassName());
        return true;
    }

    private void removeAllTables() {
        this.tables = new ArrayList<SchemaTable>();
        this.tablesByName = new HashMap<String, SchemaTable>();
    }

    private boolean addView(Element viewElement) {
        SchemaView view = new SchemaView(viewElement);
        this.views.add(view);
        this.viewsByName.put(view.getName(), view);
        return true;
    }

    private void duplicateTableViewCheck(String name) {
        if (this.tableViewNameExistsInSchema(name)) {
            throw new IllegalStateException("SchemaTable/SchemaView [" + name + "] ALREADY exists in schema");
        }
    }

    private void removeAllViews() {
        this.views = new ArrayList<SchemaView>();
        this.viewsByName = new HashMap<String, SchemaView>();
    }

    public List<SchemaTable> getTables() {
        return this.tables;
    }

    public List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>(this.tables.size());
        for (SchemaTable table : this.tables) {
            tableNames.add(table.getName());
        }
        Collections.sort(tableNames, String.CASE_INSENSITIVE_ORDER);
        return tableNames;
    }

    public SchemaTable getTable(String tableName) {
        for (SchemaTable table : this.tables) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    public SchemaView getView(String viewName) {
        for (SchemaView view : this.views) {
            if (!view.getName().equalsIgnoreCase(viewName)) continue;
            return view;
        }
        return null;
    }

    public List<SchemaView> getViews() {
        return this.views;
    }

    public boolean tableViewNameExistsInSchema(String name) {
        boolean exists = this.tablesByName.containsKey(name) || this.viewsByName.containsKey(name);
        return exists;
    }

    public ClassInfo getTableClassInfo(String tableName) {
        return this.getTableClassInfo(tableName, true);
    }

    public ClassInfo getTableClassInfo(String tableName, boolean failOnNotFound) {
        ClassInfo classInfo = null;
        String className = this.tableClassNames.get(tableName);
        if (className != null) {
            classInfo = new ClassInfo(className, null);
        } else if (classInfo == null && failOnNotFound) {
            throw new IllegalArgumentException("Cannot find table named [" + tableName + "].  Be sure that the name of the table name is correct (Including case sensitive, check foreign key table references for errors)");
        }
        return classInfo;
    }

    private void reset() {
        this.sequenceNameSet = new HashSet<String>();
    }

    public List<String> getPostSQLScriptFiles() {
        return this.postSQLScriptFiles;
    }

    public void setPostSQLScriptFiles(List<String> postSQLScriptFiles) {
        this.postSQLScriptFiles = postSQLScriptFiles;
    }

    private String prepareFilepath(String schemaFilename, String filePathToPrepare, boolean schemaXMLFilenameIsAResource, boolean relativePath) {
        String preparedFilepath;
        if (relativePath) {
            if (schemaXMLFilenameIsAResource) {
                String resourcePath = "";
                char SEPERATOR = '/';
                String pathSegment = "";
                for (int i = 0; i < schemaFilename.length(); ++i) {
                    char nextChar = schemaFilename.charAt(i);
                    if (nextChar == SEPERATOR) {
                        resourcePath = resourcePath + pathSegment + SEPERATOR;
                        pathSegment = "";
                        continue;
                    }
                    pathSegment = pathSegment + nextChar;
                }
                preparedFilepath = resourcePath + filePathToPrepare;
            } else {
                File schemaFile = new File(schemaFilename);
                int filenameSize = schemaFile.getName().length();
                String path = schemaFile.getPath();
                preparedFilepath = path.substring(0, path.length() - filenameSize) + filePathToPrepare;
            }
        } else {
            preparedFilepath = filePathToPrepare;
        }
        return preparedFilepath;
    }
}

