/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbtools.schema.ForeignKeyType;
import org.dbtools.schema.JavaType;
import org.dbtools.util.XMLUtil;
import org.dom4j.Element;

public class SchemaField {
    private String name;
    private String jdbcType;
    private int size;
    private int decimals;
    private String defaultValue;
    private boolean primaryKey;
    private boolean index;
    private boolean unique;
    private boolean createdTimeStampField;
    private boolean lastModTimeStampField;
    private boolean increment;
    public static final int DEFAULT_INITIAL_INCREMENT = 1;
    private int incrementInitialValue = 1;
    private String sequencerName;
    private int sequencerStartValue;
    private boolean notNull;
    private ForeignKeyType foreignKeyType = ForeignKeyType.IGNORE;
    public static final String FK_FETCH_LAZY = "LAZY";
    public static final String FK_FETCH_EAGER = "EAGER";
    private String foreignKeyFetchType = "LAZY";
    public static final String FK_CASCADE_ALL = "ALL";
    private String foreignKeyCascadeType = "ALL";
    private String foreignKeyField;
    private String foreignKeyTable;
    private String foreignKeyOrderByColumn;
    private String varName;
    private List<String> enumerations = new ArrayList<String>();
    private String enumerationDefault = "";
    private static Map<String, JavaType> javaTypes = new HashMap<String, JavaType>();
    public static final String TYPE_BIT = "BIT";
    public static final String TYPE_TINYINT = "TINYINT";
    public static final String TYPE_SMALLINT = "SMALLINT";
    public static final String TYPE_INTEGER = "INTEGER";
    public static final String TYPE_BIGINT = "BIGINT";
    public static final String TYPE_REAL = "REAL";
    public static final String TYPE_DOUBLE = "DOUBLE";
    public static final String TYPE_CHAR = "CHAR";
    public static final String TYPE_VARCHAR = "VARCHAR";
    public static final String TYPE_DATE = "DATE";
    public static final String TYPE_TIME = "TIME";
    public static final String TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String TYPE_JAVA_OBJECT = "JAVA_OBJECT";
    public static final String TYPE_DECIMAL = "DECIMAL";
    public static final String TYPE_NUMERIC = "NUMERIC";
    public static final String TYPE_BLOB = "BLOB";
    public static final String TYPE_CLOB = "CLOB";
    private String javaFieldNameStyleName = "";

    public SchemaField(String name, String jdbcType) {
        this.name = name;
        this.jdbcType = jdbcType;
    }

    public SchemaField(String name, int jdbcTypeID) {
        this.name = name;
        this.jdbcType = this.getJavaTypeFromJDBCTypeID(jdbcTypeID);
    }

    public SchemaField(Element fieldElement) {
        try {
            this.name = XMLUtil.getAttribute(fieldElement, "name", true);
            this.jdbcType = XMLUtil.getAttribute(fieldElement, "jdbcDataType", true);
            this.size = XMLUtil.getAttributeInt(fieldElement, "size", false, 0);
            this.decimals = XMLUtil.getAttributeInt(fieldElement, "decimals", false, 0);
            this.defaultValue = XMLUtil.getAttribute(fieldElement, "defaultValue", false);
            this.primaryKey = XMLUtil.getAttributeBoolean(fieldElement, "primaryKey", false, false);
            this.index = XMLUtil.getAttributeBoolean(fieldElement, "index", false, false);
            this.unique = XMLUtil.getAttributeBoolean(fieldElement, "unique", false, false);
            this.setCreatedTimeStampField(XMLUtil.getAttributeBoolean(fieldElement, "createdTimeStampField", false, false));
            this.lastModTimeStampField = XMLUtil.getAttributeBoolean(fieldElement, "lastModifiedTimeStampField", false, false);
            this.increment = XMLUtil.getAttributeBoolean(fieldElement, "increment", false, false);
            this.incrementInitialValue = XMLUtil.getAttributeInt(fieldElement, "incrementInitialValue", false, 1);
            this.setSequencerName(XMLUtil.getAttribute(fieldElement, "sequencerName", false));
            this.sequencerStartValue = XMLUtil.getAttributeInt(fieldElement, "sequencerStartValue", false, 1);
            this.notNull = XMLUtil.getAttributeBoolean(fieldElement, "notNull", false, false);
            this.foreignKeyField = XMLUtil.getAttribute(fieldElement, "foreignKeyField", false, "");
            this.foreignKeyTable = XMLUtil.getAttribute(fieldElement, "foreignKeyTable", false, "");
            this.setForeignKeyOrderByColumn(XMLUtil.getAttribute(fieldElement, "foreignKeyOrderByColumn", false, ""));
            this.setCustomVarName(XMLUtil.getAttribute(fieldElement, "varName", false, ""));
            String fkTypeString = XMLUtil.getAttribute(fieldElement, "foreignKeyType", false, "IGNORE");
            if (fkTypeString.equalsIgnoreCase("IGNORE")) {
                this.foreignKeyType = ForeignKeyType.IGNORE;
            } else if (fkTypeString.equalsIgnoreCase("ONETOONE")) {
                this.foreignKeyType = ForeignKeyType.ONETOONE;
            } else if (fkTypeString.equalsIgnoreCase("MANYTOONE")) {
                this.foreignKeyType = ForeignKeyType.MANYTOONE;
            } else if (fkTypeString.equalsIgnoreCase("ONETOMANY")) {
                this.foreignKeyType = ForeignKeyType.ONETOMANY;
            } else if (fkTypeString.equalsIgnoreCase("ENUM")) {
                this.foreignKeyType = ForeignKeyType.ENUM;
                this.setNotNull(true);
            } else {
                throw new IllegalArgumentException("Unknown foreignKeyType [" + fkTypeString + "]");
            }
            this.setForeignKeyFetchType(XMLUtil.getAttribute(fieldElement, "foreignKeyFetchType", false, FK_FETCH_LAZY));
            this.setForeignKeyCascadeType(XMLUtil.getAttribute(fieldElement, "foreignKeyCascadeType", false, FK_CASCADE_ALL));
            String enumArrayStr = XMLUtil.getAttribute(fieldElement, "enumerations", false, null);
            if (enumArrayStr != null && enumArrayStr.length() > 0) {
                String[] array;
                if (!this.isNumberDataType() && !this.jdbcType.equals(TYPE_VARCHAR)) {
                    throw new IllegalStateException("Enumerations can ONLY be used with INTEGER or VARCHAR datatypes for field [" + this.getName() + "]");
                }
                StringBuilder cleanEnumArrayStr = new StringBuilder();
                for (char c : enumArrayStr.toCharArray()) {
                    if (c == ' ') continue;
                    cleanEnumArrayStr.append(c);
                }
                for (String enumItem : array = cleanEnumArrayStr.toString().split(",")) {
                    this.getEnumerations().add(enumItem.trim());
                }
            }
            this.enumerationDefault = XMLUtil.getAttribute(fieldElement, "enumerationDefault", false, null);
            if ((this.enumerationDefault == null || this.enumerationDefault.isEmpty()) && !this.enumerations.isEmpty()) {
                this.enumerationDefault = this.enumerations.get(0);
            }
        }
        catch (Exception e) {
            System.out.println("Error converting field attribute." + e.getMessage());
        }
    }

    public Element toXML(Element parent) {
        Element element = parent.addElement("field");
        element.addAttribute("name", this.name);
        element.addAttribute("jdbcDataType", this.jdbcType);
        if (this.size > 0 && (this.jdbcType.equals(TYPE_VARCHAR) || this.jdbcType.equals(TYPE_DECIMAL) || this.jdbcType.equals(TYPE_NUMERIC) || this.jdbcType.equals(TYPE_DOUBLE))) {
            element.addAttribute("size", Integer.toString(this.size));
        }
        if (this.decimals > 0 && (this.jdbcType.equals(TYPE_DECIMAL) || this.jdbcType.equals(TYPE_NUMERIC) || this.jdbcType.equals(TYPE_DOUBLE))) {
            element.addAttribute("decimals", Integer.toString(this.decimals));
        }
        if (this.defaultValue != null && !this.defaultValue.equals("")) {
            element.addAttribute("defaultValue", this.defaultValue);
        }
        if (this.primaryKey) {
            element.addAttribute("primaryKey", "true");
        }
        if (this.index) {
            element.addAttribute("index", "true");
        }
        if (this.unique) {
            element.addAttribute("unique", "true");
        }
        if (this.increment) {
            element.addAttribute("increment", "true");
        }
        if (this.incrementInitialValue > 0 && (this.jdbcType.equals(TYPE_DECIMAL) || this.jdbcType.equals(TYPE_NUMERIC) || this.jdbcType.equals(TYPE_DOUBLE))) {
            element.addAttribute("incrementInitialValue", Integer.toString(this.incrementInitialValue));
        }
        if (this.getSequencerName() != null && !this.getSequencerName().equals("")) {
            element.addAttribute("sequencerName", this.getSequencerName());
        }
        if (this.sequencerStartValue > 0 && (this.jdbcType.equals(TYPE_VARCHAR) || this.jdbcType.equals(TYPE_DECIMAL) || this.jdbcType.equals(TYPE_NUMERIC) || this.jdbcType.equals(TYPE_DOUBLE))) {
            element.addAttribute("sequencerStartValue", Integer.toString(this.sequencerStartValue));
        }
        if (this.notNull) {
            element.addAttribute("notNull", "true");
        }
        if (this.lastModTimeStampField) {
            element.addAttribute("lastModifiedTimeStampField", "true");
        }
        if (this.isCreatedTimeStampField()) {
            element.addAttribute("createdTimeStampField", "true");
        }
        if (this.foreignKeyTable != null && this.foreignKeyTable.length() > 0) {
            element.addAttribute("foreignKeyTable", this.foreignKeyTable);
        }
        if (this.foreignKeyField != null && this.foreignKeyField.length() > 0) {
            element.addAttribute("foreignKeyField", this.foreignKeyField);
        }
        if (this.getForeignKeyOrderByColumn() != null && this.getForeignKeyOrderByColumn().length() > 0) {
            element.addAttribute("foreignKeyOrderByColumn", this.getForeignKeyOrderByColumn());
        }
        if (this.getCustomVarName() != null && this.getCustomVarName().length() > 0) {
            element.addAttribute("varName", this.getCustomVarName());
        }
        return element;
    }

    public JavaType getJavaType() {
        return javaTypes.get(this.jdbcType);
    }

    public static Class<?> getJavaClassType(String type, boolean isNullable) {
        if (!isNullable) {
            return javaTypes.get(type).getMainClass();
        }
        return javaTypes.get(type).getMatchingNonPrimativeClass();
    }

    public Class<?> getJavaClassType() {
        Class<?> fieldClass = null;
        fieldClass = this.isNotNull() ? javaTypes.get(this.jdbcType).getMainClass() : javaTypes.get(this.jdbcType).getMatchingNonPrimativeClass();
        return fieldClass;
    }

    public String getJavaTypeText() {
        String fieldClass = null;
        fieldClass = this.isNotNull() ? javaTypes.get(this.jdbcType).getJavaTypeText() : javaTypes.get(this.jdbcType).getMatchingNonPrimativeClassText();
        if (fieldClass == null) {
            throw new IllegalStateException("Unknown jdbcType [" + this.jdbcType + "]");
        }
        return fieldClass;
    }

    public boolean isJavaTypePrimative() {
        if (this.isNotNull()) {
            return javaTypes.get(this.jdbcType).isPrimative();
        }
        return false;
    }

    public boolean isJavaTypeImmutable() {
        return javaTypes.get(this.jdbcType).isImmutable();
    }

    private String getJavaTypeFromJDBCTypeID(int jdbcTypeID) {
        String type = "";
        switch (jdbcTypeID) {
            case -7: {
                type = TYPE_BIT;
                break;
            }
            case -6: {
                type = TYPE_TINYINT;
                break;
            }
            case 5: {
                type = TYPE_SMALLINT;
                break;
            }
            case 4: {
                type = TYPE_INTEGER;
                break;
            }
            case -5: {
                type = TYPE_BIGINT;
                break;
            }
            case 7: {
                type = TYPE_REAL;
                break;
            }
            case 8: {
                type = TYPE_DOUBLE;
                break;
            }
            case 1: {
                type = TYPE_CHAR;
                break;
            }
            case 12: {
                type = TYPE_VARCHAR;
                break;
            }
            case 91: {
                type = TYPE_DATE;
                break;
            }
            case 92: {
                type = TYPE_TIME;
                break;
            }
            case 93: {
                type = TYPE_TIMESTAMP;
                break;
            }
            case 2000: {
                type = TYPE_JAVA_OBJECT;
                break;
            }
            case 3: {
                type = TYPE_DECIMAL;
                break;
            }
            case 2: {
                type = TYPE_NUMERIC;
                break;
            }
            case 2004: {
                type = TYPE_BLOB;
                break;
            }
            case 2005: {
                type = TYPE_CLOB;
                break;
            }
            default: {
                System.out.println("WARNING... Unknown jdbc type specified: [" + jdbcTypeID + "]");
                type = "UNKNOWN";
            }
        }
        return type;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean javaFieldNameStyle) {
        if (javaFieldNameStyle) {
            String customVarName = this.getCustomVarName();
            if (customVarName != null && customVarName.length() > 0) {
                return customVarName;
            }
            if (this.javaFieldNameStyleName == null || this.javaFieldNameStyleName.equals("")) {
                boolean isAllUppercase = false;
                for (char currentChar : this.name.toCharArray()) {
                    if (Character.isUpperCase(currentChar) && Character.isLetter(currentChar)) {
                        isAllUppercase = true;
                        continue;
                    }
                    if (!Character.isLetter(currentChar)) continue;
                    isAllUppercase = false;
                    break;
                }
                String nameToConvert = isAllUppercase ? this.name.toLowerCase() : this.name;
                block4: for (int i = 0; i < nameToConvert.length(); ++i) {
                    char currentChar = nameToConvert.charAt(i);
                    switch (currentChar) {
                        case '_': {
                            currentChar = nameToConvert.charAt(++i);
                            if (!this.javaFieldNameStyleName.isEmpty()) {
                                this.javaFieldNameStyleName = this.javaFieldNameStyleName + Character.toString(currentChar).toUpperCase();
                                continue block4;
                            }
                            this.javaFieldNameStyleName = this.javaFieldNameStyleName + Character.toString(currentChar);
                            continue block4;
                        }
                        default: {
                            this.javaFieldNameStyleName = this.javaFieldNameStyleName + currentChar;
                        }
                    }
                }
            }
            return this.javaFieldNameStyleName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.javaFieldNameStyleName = "";
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isIndex() {
        return this.index;
    }

    public void setIndex(boolean index) {
        this.index = index;
    }

    public boolean isIncrement() {
        return this.increment;
    }

    public void setIncrement(boolean increment) {
        this.increment = increment;
    }

    public int getIncrementInitialValue() {
        return this.incrementInitialValue;
    }

    public void setIncrementInitialValue(int incrementInitialValue) {
        this.incrementInitialValue = incrementInitialValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFormattedClassDefaultValue() {
        return this.formatValueForField(this.defaultValue);
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getForeignKeyField() {
        return this.foreignKeyField;
    }

    public void setForeignKeyField(String foreignKeyField) {
        this.foreignKeyField = foreignKeyField;
    }

    public String getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setForeignKeyTable(String foreignKeyTable) {
        this.foreignKeyTable = foreignKeyTable;
    }

    public ForeignKeyType getForeignKeyType() {
        return this.foreignKeyType;
    }

    public void setForeignKeyType(ForeignKeyType foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public boolean isLastModifiedTimeStampField() {
        return this.lastModTimeStampField;
    }

    public void setLastModifiedTimeStampField(boolean lastModifiedTimeStampField) {
        this.lastModTimeStampField = lastModifiedTimeStampField;
    }

    public String getForeignKeyOrderByColumn() {
        return this.foreignKeyOrderByColumn;
    }

    public void setForeignKeyOrderByColumn(String foreignKeyOrderByColumn) {
        this.foreignKeyOrderByColumn = foreignKeyOrderByColumn;
    }

    public boolean isCreatedTimeStampField() {
        return this.createdTimeStampField;
    }

    public void setCreatedTimeStampField(boolean createdTimeStampField) {
        this.createdTimeStampField = createdTimeStampField;
    }

    public boolean isNumberDataType() {
        return this.jdbcType.equals(TYPE_INTEGER) || this.jdbcType.equals(TYPE_DECIMAL) || this.jdbcType.equals(TYPE_DOUBLE) || this.jdbcType.equals(TYPE_NUMERIC) || this.jdbcType.equals(TYPE_REAL) || this.jdbcType.equals(TYPE_SMALLINT) || this.jdbcType.equals(TYPE_BIGINT) || this.jdbcType.equals(TYPE_TINYINT);
    }

    public boolean isEnumeration() {
        return this.getEnumerations().size() > 0 || this.isForeignKeyIsEnumeration();
    }

    public List<String> getEnumerations() {
        return this.enumerations;
    }

    public void setEnumerations(List<String> enumerations) {
        this.enumerations = enumerations;
    }

    public String getEnumerationDefault() {
        return this.enumerationDefault;
    }

    public void setEnumerationDefault(String enumerationDefault) {
        this.enumerationDefault = enumerationDefault;
    }

    public boolean isForeignKeyIsEnumeration() {
        return this.foreignKeyType == ForeignKeyType.ENUM;
    }

    public String getSequencerName() {
        return this.sequencerName;
    }

    public void setSequencerName(String sequencerName) {
        this.sequencerName = sequencerName;
    }

    public int getSequencerStartValue() {
        return this.sequencerStartValue;
    }

    public void setSequencerStartValue(int sequencerStartValue) {
        this.sequencerStartValue = sequencerStartValue;
    }

    public String getForeignKeyFetchType() {
        return this.foreignKeyFetchType;
    }

    public void setForeignKeyFetchType(String foreignKeyFetchType) {
        this.foreignKeyFetchType = foreignKeyFetchType;
    }

    public String getForeignKeyCascadeType() {
        return this.foreignKeyCascadeType;
    }

    public void setForeignKeyCascadeType(String foreignKeyCascadeType) {
        this.foreignKeyCascadeType = foreignKeyCascadeType;
    }

    public String getCustomVarName() {
        return this.varName;
    }

    private void setCustomVarName(String varName) {
        this.varName = varName;
    }

    public String toString() {
        return this.getName();
    }

    public String formatValueForField(String inValue) {
        if (inValue == null) {
            return inValue;
        }
        String retValue = inValue;
        Class<?> c = this.getJavaClassType();
        if (c == Float.class) {
            if (!inValue.endsWith("f")) {
                retValue = inValue + 'f';
            }
        } else if (c == Long.class) {
            if (!inValue.endsWith("l")) {
                retValue = inValue + 'l';
            }
        } else if (c == Double.class && !inValue.endsWith("d")) {
            retValue = inValue + 'd';
        }
        return retValue;
    }

    static {
        javaTypes.put("BOOLEAN", new JavaType("boolean", true, true, Boolean.TYPE, Boolean.class, "Boolean"));
        javaTypes.put(TYPE_BIT, new JavaType("boolean", true, true, Boolean.TYPE, Boolean.class, "Boolean"));
        javaTypes.put(TYPE_TINYINT, new JavaType("boolean", true, true, Boolean.TYPE, Boolean.class, "Boolean"));
        javaTypes.put(TYPE_SMALLINT, new JavaType("int", true, true, Integer.TYPE, Integer.class, "Integer"));
        javaTypes.put(TYPE_INTEGER, new JavaType("int", true, true, Integer.TYPE, Integer.class, "Integer"));
        javaTypes.put(TYPE_NUMERIC, new JavaType("int", true, true, Integer.TYPE, Integer.class, "Integer"));
        javaTypes.put(TYPE_BIGINT, new JavaType("long", true, true, Long.TYPE, Long.class, "Long"));
        javaTypes.put(TYPE_REAL, new JavaType("float", true, true, Float.TYPE, Float.class, "Float"));
        javaTypes.put("FLOAT", new JavaType("float", true, true, Float.TYPE, Float.class, "Float"));
        javaTypes.put(TYPE_DOUBLE, new JavaType("double", true, true, Double.TYPE, Double.class, "Double"));
        javaTypes.put(TYPE_CHAR, new JavaType("char", true, true, Character.TYPE, Character.class, "Character"));
        javaTypes.put(TYPE_VARCHAR, new JavaType("String", false, true, String.class, String.class, "String"));
        javaTypes.put("LONGVARCHAR", new JavaType("String", false, true, String.class, String.class, "String"));
        javaTypes.put(TYPE_DATE, new JavaType("java.util.Date", false, false, Date.class, Date.class, "java.util.Date"));
        javaTypes.put(TYPE_TIME, new JavaType("Time", false, false, Time.class, Time.class, "Time"));
        javaTypes.put(TYPE_TIMESTAMP, new JavaType("java.util.Date", false, false, Date.class, Date.class, "java.util.Date"));
        javaTypes.put(TYPE_JAVA_OBJECT, new JavaType("Object", false, false, Object.class, Object.class, "Object"));
        javaTypes.put(TYPE_DECIMAL, new JavaType("float", true, true, Float.TYPE, Float.class, "Float"));
        javaTypes.put(TYPE_NUMERIC, new JavaType("float", true, true, Float.TYPE, Float.class, "Float"));
        javaTypes.put("BIGDECIMAL", new JavaType("java.math.BigDecimal", false, true, BigDecimal.class, BigDecimal.class, "java.math.BigDecimal"));
        javaTypes.put("BIGINTEGER", new JavaType("java.math.BigInteger", false, true, BigInteger.class, BigInteger.class, "java.math.BigInteger"));
        javaTypes.put(TYPE_BLOB, new JavaType("byte[]", true, true, byte[].class, Byte[].class, "Byte[]"));
        javaTypes.put(TYPE_CLOB, new JavaType("String", false, true, String.class, String.class, "String"));
    }
}

