/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.ProgressMonitor;
import org.dbtools.schema.DatabaseSchema;
import org.dbtools.schema.SQLStatement;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SchemaRenderer
implements Runnable {
    public static final String DEFAULT_TYPE_MAPPING_FILENAME = "dbmappings.xml";
    public static final String DEFAULT_TYPE_MAPPING_FILE = "/org/dbtools/xml/dbmappings.xml";
    private DatabaseSchema dbSchema = new DatabaseSchema();
    private String otherInsertsFilename = "";
    private Map<String, String> types = new HashMap<String, String>();
    private Map<String, String> javaTypes = new HashMap<String, String>();
    private PrintStream ps = null;
    private static Map<String, String> dbRenderers = new TreeMap<String, String>();
    private Component parentComponent;
    private String dbVendorName;
    private String databaseName;
    private String schemaXMLFilename;
    private boolean schemaXMLFilenameIsAResource = false;
    private String outputFile;
    private String[] tablesToGenerate;
    private boolean createSchema = true;
    private String[] viewsToGenerate;
    private boolean dropTables = false;
    private boolean executeSQLScriptFiles;
    private boolean createONLYOtherInserts = false;
    private boolean createPostSchema = true;
    private boolean createEnumInserts = true;
    private Map<String, SchemaTable> alreadyCreatedEnum = new HashMap<String, SchemaTable>();
    private boolean showConsoleProgress = false;
    private ProgressMonitor pm = null;
    private int currProgress = 0;
    private int maxProgress = 0;
    private String mappingFilename = "dbmappings.xml";

    public SchemaRenderer() {
        this.setDefaults();
    }

    public SchemaRenderer(PrintStream ps) {
        this.ps = ps;
        this.setDefaults();
    }

    public SchemaRenderer(Component parentComponent, String dbVendorName, String databaseName, String schemaXMLFilename, String outputFile, String[] tablesToGenerate, boolean dropTables, boolean createInserts, PrintStream ps) {
        this.init(parentComponent, dbVendorName, schemaXMLFilename, outputFile, tablesToGenerate, dropTables, createInserts, ps);
    }

    public void readXMLSchema(String path, String dbVendorName) {
        this.dbSchema.readXMLSchema(path, dbVendorName, false, this.ps);
    }

    private void setDefaults() {
        if (this.ps == null) {
            this.ps = System.out;
        }
    }

    public void init(Component parentComponent, String dbVendorName, String schemaXMLFilename, String outputFile, String[] tablesToGenerate, boolean dropTables, boolean executeSQLScriptFiles, PrintStream ps) {
        this.parentComponent = parentComponent;
        this.dbVendorName = dbVendorName;
        this.schemaXMLFilename = schemaXMLFilename;
        this.outputFile = outputFile;
        this.tablesToGenerate = tablesToGenerate;
        this.dropTables = dropTables;
        this.executeSQLScriptFiles = executeSQLScriptFiles;
        this.ps = ps;
        this.setDefaults();
    }

    private void addProgress(int value) {
        this.currProgress += value;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this.pm != null) {
            this.pm.setProgress(this.currProgress);
        }
    }

    private void calculateProgress(SchemaDatabase database) {
        if (this.executeSQLScriptFiles && database.getPostSQLScriptFiles() != null && !this.createONLYOtherInserts) {
            for (String insertsFilename : database.getPostSQLScriptFiles()) {
                try {
                    File insertsFile = new File(insertsFilename);
                    this.maxProgress += (int)insertsFile.length();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.executeSQLScriptFiles && this.otherInsertsFilename.length() > 0) {
            File insertsFile = new File(this.otherInsertsFilename);
            this.maxProgress += (int)insertsFile.length();
        }
    }

    public static synchronized boolean readXMLTypes(Class<?> classLoaderClass, String typesFilename, String dbVendorName, Map<String, String> types, Map<String, String> javaTypes) {
        File xmlMappingFile = new File(typesFilename);
        if (!(xmlMappingFile.exists() || (xmlMappingFile = new File("xml/" + typesFilename)).exists() || (xmlMappingFile = new File("../xml/" + typesFilename)).exists())) {
            xmlMappingFile = null;
        }
        InputStream xmlMappingInputStream = null;
        if (xmlMappingFile == null) {
            xmlMappingInputStream = classLoaderClass.getResourceAsStream(DEFAULT_TYPE_MAPPING_FILE);
        }
        if (xmlMappingFile == null && xmlMappingInputStream == null) {
            throw new IllegalStateException("Failed to find mapping file: [" + typesFilename + "] and from classpath!");
        }
        try {
            SAXReader xmlReader = new SAXReader(false);
            Document doc = null;
            if (xmlMappingFile != null) {
                String pathname = xmlMappingFile.getAbsolutePath();
                doc = xmlReader.read(new File(pathname));
            } else {
                doc = xmlReader.read(xmlMappingInputStream);
            }
            Element root = doc.getRootElement();
            Element typeMappingsElement = root.element("type-mappings");
            Iterator typeMappingsItr = typeMappingsElement.elementIterator();
            boolean found = false;
            while (typeMappingsItr.hasNext() && !found) {
                Element typeMappingElement = (Element)typeMappingsItr.next();
                String dbMapping = typeMappingElement.element("name").getText();
                if (!dbMapping.equalsIgnoreCase(dbVendorName)) continue;
                found = true;
                Iterator mappingItr = typeMappingElement.elementIterator("mapping");
                while (mappingItr.hasNext()) {
                    Element mappingElement = (Element)mappingItr.next();
                    String jdbcType = mappingElement.element("jdbc-type").getText();
                    String javaType = mappingElement.element("java-type").getText();
                    String sqlType = mappingElement.element("sql-type").getText();
                    javaTypes.put(jdbcType, javaType);
                    types.put(jdbcType, sqlType);
                }
            }
            if (!found) {
                System.out.println("Database Mappings could not be found for [" + dbVendorName + "].  Check dbmappings.xml file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean writeSchema(SchemaDatabase database, String pathname, String schema, boolean addInserts) {
        this.showProgress("Writing file [" + pathname + "]...", true);
        File outFile = new File(pathname);
        try {
            PrintStream fps = new PrintStream(new FileOutputStream(outFile));
            fps.print(schema);
            if (addInserts) {
                if (database.getPostSQLScriptFiles() != null && !this.createONLYOtherInserts) {
                    for (String insertsFilename : database.getPostSQLScriptFiles()) {
                        try {
                            this.addInsertsToSQL(fps, insertsFilename);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (this.otherInsertsFilename.length() > 0) {
                    this.addInsertsToSQL(fps, this.otherInsertsFilename);
                }
            }
            if (this.createPostSchema) {
                fps.print(this.generatePostSchema(database, this.tablesToGenerate));
            }
            fps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void addInsertsToSQL(PrintStream fps, String insertsFilename) throws IOException {
        BufferedReader insertsReader;
        if (this.schemaXMLFilenameIsAResource) {
            InputStream insertsInputStream = this.getClass().getResourceAsStream(insertsFilename);
            if (insertsInputStream == null) {
                this.showProgress("Failed to read 'inserts' resource [" + insertsFilename + "]", true);
            }
            insertsReader = new BufferedReader(new InputStreamReader(insertsInputStream));
        } else {
            insertsReader = new BufferedReader(new FileReader(insertsFilename));
        }
        while (insertsReader.ready()) {
            SQLStatement sqlStmnt;
            String line = insertsReader.readLine();
            this.addProgress(line.length());
            boolean skip = false;
            if (line.startsWith("//")) {
                skip = true;
            }
            if (this.createEnumInserts && (sqlStmnt = new SQLStatement(line)).isInsert() && this.alreadyCreatedEnum.containsKey(sqlStmnt.getTable())) {
                skip = true;
            }
            if (skip) continue;
            fps.println(line);
        }
    }

    public boolean executeRenderer() {
        SchemaRenderer.readXMLTypes(this.getClass(), this.mappingFilename, this.dbVendorName, this.types, this.javaTypes);
        this.showProgress("Reading XML Schema...", true);
        this.dbSchema.readXMLSchema(this.schemaXMLFilename, this.dbVendorName, this.schemaXMLFilenameIsAResource, this.ps);
        if (this.databaseName != null && this.databaseName.isEmpty()) {
            return this.renderDatabase(this.dbSchema.getDatabase(this.databaseName));
        }
        for (SchemaDatabase database : this.dbSchema.getSchemaDatabases()) {
            if (this.renderDatabase(database)) continue;
            return false;
        }
        return true;
    }

    private boolean renderDatabase(SchemaDatabase database) {
        this.calculateProgress(database);
        this.pm = null;
        if (this.parentComponent != null && this.maxProgress > 0) {
            this.showConsoleProgress = false;
            this.pm = new ProgressMonitor(this.parentComponent, "Creating Schema", "", 0, this.maxProgress);
            this.pm.setMillisToPopup(0);
        } else {
            this.showConsoleProgress = true;
        }
        String newSchema = "";
        if (this.createSchema) {
            newSchema = this.generateSchema(database, this.tablesToGenerate, this.viewsToGenerate, this.dropTables, this.executeSQLScriptFiles);
        }
        boolean success = this.writeSchema(database, this.outputFile, newSchema, this.executeSQLScriptFiles);
        this.showProgress("Schema Rendering Completed.", true);
        if (this.pm != null) {
            this.pm.close();
        }
        return success;
    }

    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using default renderer ...", false);
        StringBuilder schema = new StringBuilder();
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(false, true, schema, requestedTables, requestedViews);
        }
        for (SchemaTable table : requestedTables) {
            schema.append("CREATE TABLE ");
            schema.append(table.getName());
            schema.append(" (\n");
            List<SchemaField> fields = table.getFields();
            SchemaField enumPKField = null;
            SchemaField enumValueField = null;
            for (int j = 0; j < fields.size(); ++j) {
                SchemaField field = fields.get(j);
                schema.append("\t");
                schema.append(field.getName());
                schema.append(" ");
                schema.append(this.types.get(field.getJdbcType()));
                if (field.getSize() > 0) {
                    schema.append("(");
                    schema.append(field.getSize());
                    schema.append(")");
                }
                schema.append("");
                if (j == fields.size() - 1) {
                    schema.append("\n");
                } else {
                    schema.append(",\n");
                }
                if (enumPKField == null && field.isPrimaryKey()) {
                    enumPKField = field;
                }
                if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
                enumValueField = field;
            }
            schema.append(");\n\n");
            SchemaRenderer.generateEnumSchema(schema, table, this.alreadyCreatedEnum, enumPKField, enumValueField, this.createEnumInserts);
        }
        this.showProgress("complete", true);
        return schema.toString();
    }

    public static boolean enumInsertsWillBeCreated(SchemaTable table, SchemaField enumPKField, SchemaField enumValueField, boolean createInserts) {
        return table.isEnumerationTable() && createInserts && enumPKField != null && enumValueField != null;
    }

    public static int generateEnumSchema(StringBuilder schema, SchemaTable table, Map<String, SchemaTable> alreadyCreatedEnum, SchemaField enumPKField, SchemaField enumValueField, boolean createInserts) {
        return SchemaRenderer.generateEnumSchema(schema, table, alreadyCreatedEnum, enumPKField, enumValueField, createInserts, 0);
    }

    public static int generateEnumSchema(StringBuilder schema, SchemaTable table, Map<String, SchemaTable> alreadyCreatedEnum, SchemaField enumPKField, SchemaField enumValueField, boolean createInserts, int ordinalStartValue) {
        int enumPKID = ordinalStartValue;
        if (SchemaRenderer.enumInsertsWillBeCreated(table, enumPKField, enumValueField, createInserts)) {
            alreadyCreatedEnum.put(table.getName().toLowerCase(), table);
            schema.append("\n");
            Map<String, String> enumValues = table.getEnumValues();
            for (String enumItem : table.getEnumerations()) {
                schema.append("INSERT INTO ").append(table.getName());
                schema.append(" (").append(enumPKField.getName()).append(", ").append(enumValueField.getName()).append(")");
                schema.append(" VALUES (").append(enumPKID).append(", '").append(enumValues.get(enumItem)).append("');\n");
                ++enumPKID;
            }
            schema.append("\n");
        }
        return enumPKID;
    }

    public Map<String, SchemaTable> getAlreadyCreatedEnum() {
        return this.alreadyCreatedEnum;
    }

    public static String generateDropSchema(boolean addIfExists, SchemaTable table) {
        if (addIfExists) {
            return "DROP TABLE IF EXISTS " + table.getName() + ";";
        }
        return "DROP TABLE " + table.getName() + ";";
    }

    public void generateDropSchema(boolean addIfExists, boolean ifExistsAtEndOfStmnt, StringBuilder schema, List<SchemaTable> tablesToGenerate, List<SchemaView> viewsToGenerate) {
        ArrayList<String> inverseViews = new ArrayList<String>();
        ArrayList<String> inverseTables = new ArrayList<String>();
        String ifExists = "";
        if (addIfExists) {
            ifExists = " IF EXISTS ";
        }
        for (SchemaView schemaView : viewsToGenerate) {
            inverseViews.add(0, schemaView.getName());
        }
        for (SchemaTable schemaTable : tablesToGenerate) {
            inverseTables.add(0, schemaTable.getName());
        }
        for (String string : inverseViews) {
            if (ifExistsAtEndOfStmnt) {
                schema.append("DROP VIEW ").append(string).append(ifExists).append(";\n");
                continue;
            }
            schema.append("DROP VIEW ").append(ifExists).append(string).append(";\n");
        }
        schema.append("\n");
        for (String string : inverseTables) {
            if (ifExistsAtEndOfStmnt) {
                schema.append("DROP TABLE ").append(string).append(ifExists).append(";\n");
                continue;
            }
            schema.append("DROP TABLE ").append(ifExists).append(string).append(";\n");
        }
        schema.append("\n");
    }

    public String generatePostSchema(SchemaDatabase database, String[] tablesToGenerate) {
        this.showProgress("Generating Post SQL schema using default renderer...", false);
        this.showProgress("complete", true);
        return "";
    }

    public static void main(String[] args) {
        String line = "    INSERT INTO    Customer";
        StringTokenizer st = new StringTokenizer(line, " ", false);
        while (st.hasMoreTokens()) {
            System.out.println("Token: " + st.nextToken());
        }
    }

    public static List<String> getRendererNames() {
        ArrayList<String> renderers = new ArrayList<String>();
        Iterator<Map.Entry<String, String>> i$ = dbRenderers.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> e = stringStringEntry = i$.next();
            renderers.add(e.getKey());
        }
        return renderers;
    }

    public static SchemaRenderer getRenderer(String name) {
        SchemaRenderer renderer = null;
        String className = dbRenderers.get(name.toLowerCase().trim());
        if (className != null) {
            try {
                renderer = (SchemaRenderer)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.out.println("Could not find specified renderer [" + name + "] from known list, trying to load by given name...");
                try {
                    renderer = (SchemaRenderer)Class.forName(className).newInstance();
                }
                catch (Exception ex) {
                    System.out.println("Could load specified renderer [" + name + "]... using default");
                    renderer = new SchemaRenderer();
                }
            }
        }
        return renderer;
    }

    public List<SchemaTable> getTablesToGenerate(SchemaDatabase database, String[] tablesToGenerate) {
        ArrayList<SchemaTable> requestedTables = new ArrayList<SchemaTable>();
        if (tablesToGenerate == null || tablesToGenerate.length > 0 && tablesToGenerate[0] == null) {
            requestedTables.addAll(database.getTables());
        } else {
            for (String tableToGenerate : tablesToGenerate) {
                SchemaTable table = database.getTable(tableToGenerate);
                if (table != null) {
                    requestedTables.add(table);
                    continue;
                }
                this.showProgress("WARNING: Could not find requested table [" + tableToGenerate + "].", true);
            }
        }
        return SchemaRenderer.getTablesInCreateOrder(requestedTables);
    }

    public static List<SchemaTable> getTablesInCreateOrder(List<SchemaTable> requestedTables) {
        ArrayList<SchemaTable> orderedTables = new ArrayList<SchemaTable>();
        int lastOrderedTablesSize = 0;
        ArrayList<SchemaTable> tablesNotYetAdded = new ArrayList<SchemaTable>(requestedTables);
        ArrayList<SchemaTable> tablesCouldNotBeAdded = new ArrayList<SchemaTable>();
        while (tablesNotYetAdded.size() > 0) {
            tablesCouldNotBeAdded = new ArrayList();
            for (SchemaTable table : tablesNotYetAdded) {
                if (SchemaRenderer.tableListContainsAllFKFields(orderedTables, table)) {
                    orderedTables.add(table);
                    continue;
                }
                tablesCouldNotBeAdded.add(table);
            }
            if (lastOrderedTablesSize == orderedTables.size()) {
                for (SchemaTable missingDepTable : tablesNotYetAdded) {
                    System.out.println("WARNING: Could not find dependency table for table: [" + missingDepTable.getName() + "]");
                    orderedTables.add(missingDepTable);
                }
                break;
            }
            lastOrderedTablesSize = orderedTables.size();
            tablesNotYetAdded = new ArrayList(tablesCouldNotBeAdded);
        }
        return orderedTables;
    }

    private static boolean tableListContainsAllFKFields(List<SchemaTable> orderedTables, SchemaTable table) {
        for (SchemaField field : table.getFields()) {
            String fkTable = field.getForeignKeyTable();
            if (fkTable == null || fkTable.length() <= 0 || SchemaRenderer.tableListContainsTable(orderedTables, fkTable) || fkTable.equalsIgnoreCase(table.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean tableListContainsTable(List<SchemaTable> tables, String tableToMatch) {
        if (tableToMatch == null) {
            return false;
        }
        for (SchemaTable table : tables) {
            if (!table.getName().equals(tableToMatch)) continue;
            return true;
        }
        return false;
    }

    public List<SchemaView> getViewsToGenerate(SchemaDatabase database, String[] viewsToGenerate) {
        ArrayList<SchemaView> requestedViews = new ArrayList<SchemaView>();
        if (viewsToGenerate == null || viewsToGenerate.length > 0 && viewsToGenerate[0] == null) {
            requestedViews.addAll(database.getViews());
        } else {
            for (String viewToGenerate : viewsToGenerate) {
                SchemaView view = database.getView(viewToGenerate);
                if (view != null) {
                    requestedViews.add(view);
                    continue;
                }
                this.showProgress("WARNING: Could not find requested view [" + viewToGenerate + "].", true);
            }
        }
        return requestedViews;
    }

    public String formatDefaultValue(SchemaField field) {
        return SchemaRenderer.formatBaseDefaultValue(field);
    }

    public static String formatBaseDefaultValue(SchemaField field) {
        String defaultValue = field.getDefaultValue();
        String newDefaultValue = "";
        Class<?> javaType = field.getJavaClassType();
        if (defaultValue.equalsIgnoreCase("NULL")) {
            return defaultValue;
        }
        newDefaultValue = javaType == String.class ? "'" + defaultValue + "'" : (javaType == Boolean.TYPE ? (defaultValue.equalsIgnoreCase("true") || defaultValue.equals("1") ? "1" : "0") : (javaType == Date.class ? "'" + defaultValue + "'" : (javaType == Calendar.class ? "'" + defaultValue + "'" : defaultValue)));
        return newDefaultValue;
    }

    protected void showProgress(String text, boolean newLine) {
        if (this.showConsoleProgress) {
            if (newLine) {
                this.ps.println(text);
            } else {
                this.ps.print(text);
            }
        }
    }

    @Override
    public void run() {
        this.executeRenderer();
    }

    public String getSchemaXMLFilename() {
        return this.schemaXMLFilename;
    }

    public void setSchemaXMLFilename(String schemaXMLFilename) {
        this.schemaXMLFilename = schemaXMLFilename;
        this.schemaXMLFilenameIsAResource = false;
    }

    public void setSchemaXMLFilename(String schemaXMLFilename, boolean isResource) {
        this.schemaXMLFilename = schemaXMLFilename;
        this.schemaXMLFilenameIsAResource = isResource;
    }

    public String[] getTablesToGenerate() {
        return this.tablesToGenerate;
    }

    public void setTablesToGenerate(String[] tablesToGenerate) {
        this.tablesToGenerate = tablesToGenerate;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public boolean isExecuteSQLScriptFiles() {
        return this.executeSQLScriptFiles;
    }

    public void setExecuteSQLScriptFiles(boolean executeSQLScriptFiles) {
        this.executeSQLScriptFiles = executeSQLScriptFiles;
    }

    public boolean isShowConsoleProgress() {
        return this.showConsoleProgress;
    }

    public void setShowConsoleProgress(boolean showConsoleProgress) {
        this.showConsoleProgress = showConsoleProgress;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDbVendorName() {
        return this.dbVendorName;
    }

    public void setDbVendorName(String dbVendorName) {
        if (!dbRenderers.containsKey(dbVendorName.toLowerCase())) {
            throw new IllegalArgumentException("Cannot find a renderer for Vendor [" + dbVendorName.toLowerCase() + "]");
        }
        this.dbVendorName = dbVendorName;
    }

    public String[] getViewsToGenerate() {
        return this.viewsToGenerate;
    }

    public void setViewsToGenerate(String[] viewsToGenerate) {
        this.viewsToGenerate = viewsToGenerate;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isCreatePostSchema() {
        return this.createPostSchema;
    }

    public void setCreatePostSchema(boolean createPostSchema) {
        this.createPostSchema = createPostSchema;
    }

    public String getMappingFilename() {
        return this.mappingFilename;
    }

    public void setMappingFilename(String mappingFilename) {
        this.mappingFilename = mappingFilename;
    }

    public DatabaseSchema getDbSchema() {
        return this.dbSchema;
    }

    public String getOtherInsertsFilename() {
        return this.otherInsertsFilename;
    }

    public void setOtherInsertsFilename(String otherInsertsFilename) {
        this.otherInsertsFilename = otherInsertsFilename;
    }

    public boolean isCreateONLYOtherInserts() {
        return this.createONLYOtherInserts;
    }

    public void setCreateONLYOtherInserts(boolean createONLYOtherInserts) {
        this.createONLYOtherInserts = createONLYOtherInserts;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public boolean isCreateEnumInserts() {
        return this.createEnumInserts;
    }

    public void setCreateEnumInserts(boolean createEnumInserts) {
        this.createEnumInserts = createEnumInserts;
    }

    public SchemaDatabase getDatabase() {
        return this.getDbSchema().getDatabase(this.databaseName);
    }

    static {
        dbRenderers.put("derby", "com.jdc.db.schema.DerbyRenderer");
        dbRenderers.put("sqlite", "com.jdc.db.schema.SqliteRenderer");
        dbRenderers.put("firebird", "com.jdc.db.schema.FireBirdRenderer");
        dbRenderers.put("hsqldb", "com.jdc.db.schema.HSQLDBRenderer");
        dbRenderers.put("ianywhere", "com.jdc.db.schema.IAnywhereRenderer");
        dbRenderers.put("mysql", "com.jdc.db.schema.MySQLRenderer");
        dbRenderers.put("postgresql", "com.jdc.db.schema.PostgreSQLRenderer");
        dbRenderers.put("oracle", "com.jdc.db.schema.Oracle9Renderer");
    }
}

