/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dbtools.schema.SchemaField;
import org.dbtools.util.XMLUtil;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class SchemaTable {
    private String name;
    private String className;
    private Map<String, String> tableParameters = new HashMap<String, String>();
    private SchemaField primaryKey;
    private List<SchemaField> fields = new ArrayList<SchemaField>();
    private List<List<String>> uniqueDeclarations = new ArrayList<List<String>>();
    private List<String> enumerations = new ArrayList<String>();
    private Map<String, String> enumValues = new HashMap<String, String>();

    public SchemaTable(String name) {
        this.name = name;
    }

    public SchemaTable(String db, Element tableElement) {
        this.name = tableElement.attribute("name").getValue();
        Attribute classNameAttr = tableElement.attribute("className");
        this.className = classNameAttr != null ? classNameAttr.getValue() : SchemaTable.createJavaStyleName(this.name);
        for (Element pElement : tableElement.elements("tableParameter")) {
            String dbName = pElement.attribute("db").getValue();
            if (db == null || !db.toUpperCase().equals(dbName.toString().toUpperCase())) continue;
            this.tableParameters.put(pElement.attribute("name").getValue(), pElement.attribute("value").getValue());
        }
        String enumArrayStr = XMLUtil.getAttribute(tableElement, "enumerations", false, null);
        if (enumArrayStr != null && enumArrayStr.length() > 0) {
            StringBuilder cleanEnumArrayStr = new StringBuilder();
            boolean afterEqual = false;
            for (char c : enumArrayStr.toCharArray()) {
                if (c == '=') {
                    afterEqual = true;
                }
                if (c == ' ' && !afterEqual) continue;
                cleanEnumArrayStr.append(c);
            }
            String enumItem = "";
            String enumValue = "";
            afterEqual = false;
            int charCount = 0;
            for (char c : enumArrayStr.toCharArray()) {
                ++charCount;
                if (c == ',') {
                    this.addEnumItem(enumValue.trim(), enumItem.trim());
                    enumItem = "";
                    enumValue = "";
                    afterEqual = false;
                    continue;
                }
                if (c == '=' && !afterEqual) {
                    afterEqual = true;
                    continue;
                }
                if (!afterEqual) {
                    enumItem = enumItem + c;
                } else {
                    enumValue = enumValue + c;
                }
                if (charCount != enumArrayStr.length()) continue;
                this.addEnumItem(enumValue.trim(), enumItem.trim());
            }
        }
        for (Element fieldElement : tableElement.elements("field")) {
            SchemaField newField = this.addField(fieldElement);
            if (!newField.isPrimaryKey()) continue;
            if (this.getPrimaryKey() != null) {
                throw new IllegalStateException("Cannot have 2 primary key fields for table [" + this.getName() + "].[" + newField.getName() + "]");
            }
            this.setPrimaryKey(newField);
        }
        for (Element uElement : tableElement.elements("unique")) {
            ArrayList<String> uniqueFields = new ArrayList<String>();
            Iterator uniqueFieldsItr = uElement.elementIterator("uniqueField");
            while (uniqueFieldsItr.hasNext()) {
                Element ufElement = (Element)uniqueFieldsItr.next();
                String uniqueField = ufElement.attribute("name").getValue();
                uniqueFields.add(uniqueField);
            }
            this.uniqueDeclarations.add(uniqueFields);
        }
    }

    public SchemaField addField(SchemaField newField) {
        this.fields.add(newField);
        return newField;
    }

    private void addEnumItem(String enumValue, String enumItem) {
        this.enumerations.add(enumItem);
        if (enumValue.length() != 0) {
            this.enumValues.put(enumItem, enumValue);
        } else {
            int prevEnumChar = 32;
            String newEnumValue = "";
            int enumItemItr = 0;
            for (int n : enumItem.toCharArray()) {
                newEnumValue = enumItemItr == 0 || prevEnumChar == 95 ? newEnumValue + Character.toUpperCase((char)n) : (n == 95 ? newEnumValue + " " : newEnumValue + Character.toLowerCase((char)n));
                prevEnumChar = n;
                ++enumItemItr;
            }
            this.enumValues.put(enumItem, newEnumValue);
        }
    }

    private SchemaField addField(Element fieldElement) {
        return this.addField(new SchemaField(fieldElement));
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public static String createJavaStyleName(String tableName) {
        String javaClassnameStyleName = "";
        boolean isAllUppercase = false;
        for (char currentChar : tableName.toCharArray()) {
            if (Character.isUpperCase(currentChar) && Character.isLetter(currentChar)) {
                isAllUppercase = true;
                continue;
            }
            if (!Character.isLetter(currentChar)) continue;
            isAllUppercase = false;
            break;
        }
        String nameToConvert = isAllUppercase ? tableName.toLowerCase() : tableName;
        block4: for (int i = 0; i < nameToConvert.length(); ++i) {
            char currentChar = nameToConvert.charAt(i);
            if (i == 0) {
                javaClassnameStyleName = javaClassnameStyleName + Character.toString(currentChar).toUpperCase();
                continue;
            }
            switch (currentChar) {
                case '_': {
                    currentChar = nameToConvert.charAt(++i);
                    javaClassnameStyleName = javaClassnameStyleName + Character.toString(currentChar).toUpperCase();
                    continue block4;
                }
                default: {
                    javaClassnameStyleName = javaClassnameStyleName + currentChar;
                }
            }
        }
        return javaClassnameStyleName;
    }

    public SchemaField getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(SchemaField primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<SchemaField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<SchemaField> getForeignKeyFields(String tableName) {
        ArrayList<SchemaField> fkFields = new ArrayList<SchemaField>();
        for (SchemaField field : this.fields) {
            String fkTable = field.getForeignKeyTable();
            if (fkTable == null || !fkTable.equalsIgnoreCase(tableName)) continue;
            fkFields.add(field);
        }
        return fkFields;
    }

    public List<SchemaField> getForeignKeyFields() {
        ArrayList<SchemaField> fkFields = new ArrayList<SchemaField>();
        for (SchemaField field : this.fields) {
            String fkTable = field.getForeignKeyTable();
            if (fkTable == null || fkTable.length() <= 0) continue;
            fkFields.add(field);
        }
        return fkFields;
    }

    public void setFields(List<SchemaField> fields) {
        this.fields = fields;
    }

    public String getParameter(String key) {
        return this.tableParameters.get(key);
    }

    public List<List<String>> getUniqueDeclarations() {
        return Collections.unmodifiableList(this.uniqueDeclarations);
    }

    public void setUniqueDeclarations(List<List<String>> uniqueDeclarations) {
        this.uniqueDeclarations = uniqueDeclarations;
    }

    public Element toXML(Element parent) {
        Element element = parent.addElement("table");
        element.addAttribute("name", this.name);
        if (this.className != null && this.className.length() > 0) {
            element.addAttribute("className", this.name);
        }
        for (SchemaField field : this.getFields()) {
            field.toXML(element);
        }
        return element;
    }

    public List<String> getEnumerations() {
        return Collections.unmodifiableList(this.enumerations);
    }

    public void setEnumerations(List<String> enumerations) {
        this.enumerations = enumerations;
    }

    public Map<String, String> getEnumValues() {
        return Collections.unmodifiableMap(this.enumValues);
    }

    public boolean isEnumerationTable() {
        return this.enumerations.size() > 0;
    }

    public String toString() {
        return this.getName();
    }
}

