/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbtools.schema.SchemaViewField;
import org.dom4j.Element;

public class SchemaView {
    private String name;
    private String viewPostSelectClause;
    private List<SchemaViewField> viewFields = new ArrayList<SchemaViewField>();

    public SchemaView(String name) {
        this.name = name;
    }

    public SchemaView(Element viewElement) {
        this.name = viewElement.attribute("name").getValue();
        this.viewPostSelectClause = viewElement.element("viewPostSelectClause").getText();
        Iterator viewFieldsItr = viewElement.elementIterator("viewField");
        while (viewFieldsItr.hasNext()) {
            Element viewFieldElement = (Element)viewFieldsItr.next();
            this.addViewField(viewFieldElement);
        }
    }

    public boolean addViewField(SchemaViewField newViewField) {
        this.viewFields.add(newViewField);
        return true;
    }

    private boolean addViewField(Element viewFieldElement) {
        this.viewFields.add(new SchemaViewField(viewFieldElement));
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SchemaViewField> getViewFields() {
        return this.viewFields;
    }

    public void setViewFields(List<SchemaViewField> viewFields) {
        this.viewFields = viewFields;
    }

    public String getViewPostSelectClause() {
        return this.viewPostSelectClause;
    }

    public void setViewPostSelectClause(String viewPostSelectClause) {
        this.viewPostSelectClause = viewPostSelectClause;
    }
}

