/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dbtools.schema.SchemaViewField;

public class SqliteRenderer
extends SchemaRenderer {
    public static final String RENDERER_NAME = "sqlite";

    public SqliteRenderer() {
        this.setDbVendorName(RENDERER_NAME);
    }

    public SqliteRenderer(PrintStream ps) {
        super(ps);
        this.setDbVendorName(RENDERER_NAME);
    }

    @Override
    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using Sqlite renderer ...", true);
        StringBuilder schema = new StringBuilder();
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(false, true, schema, requestedTables, requestedViews);
        }
        for (SchemaTable table : requestedTables) {
            schema.append(SqliteRenderer.generateTableSchema(table, this.getTypes()));
        }
        for (SchemaView view : requestedViews) {
            schema.append("CREATE VIEW ").append(view.getName()).append(" AS \n");
            schema.append("  SELECT \n");
            Iterator<SchemaViewField> vfItr = view.getViewFields().iterator();
            while (vfItr.hasNext()) {
                SchemaViewField viewField = vfItr.next();
                schema.append("\t").append(viewField.getExpression()).append(" ").append(viewField.getName());
                if (vfItr.hasNext()) {
                    schema.append(",\n");
                    continue;
                }
                schema.append("\n");
            }
            schema.append("  ").append(view.getViewPostSelectClause()).append(";");
            schema.append("\n\n");
        }
        return schema.toString();
    }

    @Override
    public String formatDefaultValue(SchemaField field) {
        return SqliteRenderer.formatSqliteDefaultValue(field);
    }

    public static String formatSqliteDefaultValue(SchemaField field) {
        String defaultValue = field.getDefaultValue();
        String newDefaultValue = "";
        Class<?> javaType = field.getJavaClassType();
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            newDefaultValue = defaultValue.equalsIgnoreCase("TRUE") || defaultValue.equals("1") ? "1" : "0";
        } else if (javaType == Date.class) {
            if (defaultValue.equalsIgnoreCase("now")) {
                newDefaultValue = "CURRENT_TIMESTAMP";
            }
        } else {
            newDefaultValue = SchemaRenderer.formatBaseDefaultValue(field);
        }
        return newDefaultValue;
    }

    @Override
    public String generatePostSchema(SchemaDatabase database, String[] tablesToGenerate) {
        StringBuilder postSchema = new StringBuilder();
        postSchema.append("\n\n");
        return postSchema.toString();
    }

    public static String generateTableSchema(SchemaTable table, Map<String, String> types) {
        StringBuilder tableSchema = new StringBuilder();
        tableSchema.append("CREATE TABLE IF NOT EXISTS ");
        tableSchema.append(table.getName());
        tableSchema.append(" (\n");
        List<SchemaField> fields = table.getFields();
        ArrayList<SchemaField> indexFields = new ArrayList<SchemaField>();
        ArrayList<SchemaField> uniqueFields = new ArrayList<SchemaField>();
        SchemaField enumPKField = null;
        SchemaField enumValueField = null;
        for (int j = 0; j < fields.size(); ++j) {
            SchemaField field = fields.get(j);
            String fieldName = field.getName();
            tableSchema.append("\t");
            tableSchema.append(fieldName);
            tableSchema.append(" ");
            tableSchema.append(types.get(field.getJdbcType()));
            String defaultValue = field.getDefaultValue();
            if (defaultValue != null && !defaultValue.equals("")) {
                tableSchema.append(" DEFAULT ").append(SqliteRenderer.formatSqliteDefaultValue(field));
            }
            if (field.isNotNull() && !field.isIncrement()) {
                tableSchema.append(" NOT NULL");
            }
            if (field.isPrimaryKey()) {
                tableSchema.append(" PRIMARY KEY");
            }
            if (field.isIncrement()) {
                tableSchema.append("  AUTOINCREMENT");
            }
            if (field.isUnique()) {
                uniqueFields.add(field);
            }
            if (field.isIndex()) {
                indexFields.add(field);
            }
            tableSchema.append("");
            if (j == fields.size() - 1) {
                if (uniqueFields.size() > 0) {
                    tableSchema.append(",\n\tUNIQUE(");
                    for (int k = 0; k < uniqueFields.size(); ++k) {
                        SchemaField uField = (SchemaField)uniqueFields.get(k);
                        if (k != 0) {
                            tableSchema.append(", ");
                        }
                        tableSchema.append(uField.getName());
                    }
                    tableSchema.append(")");
                }
                for (SchemaField foreignKeyField : table.getForeignKeyFields()) {
                    tableSchema.append(",\n\tFOREIGN KEY (");
                    tableSchema.append(foreignKeyField.getName()).append(") REFERENCES ").append(foreignKeyField.getForeignKeyTable());
                    tableSchema.append(" (").append(foreignKeyField.getForeignKeyField()).append(")");
                }
            } else {
                tableSchema.append(",\n");
            }
            if (enumPKField == null && field.isPrimaryKey()) {
                enumPKField = field;
            }
            if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
            enumValueField = field;
        }
        List<List<String>> uniqueDeclarations = table.getUniqueDeclarations();
        for (List<String> uniqueDeclaration : uniqueDeclarations) {
            String uniqueFieldString = "";
            for (int k = 0; k < uniqueDeclaration.size(); ++k) {
                String uniqueField = uniqueDeclaration.get(k);
                if (k > 0) {
                    uniqueFieldString = uniqueFieldString + ", ";
                }
                uniqueFieldString = uniqueFieldString + uniqueField;
            }
            tableSchema.append(",\n\tUNIQUE(").append(uniqueFieldString).append(")");
        }
        tableSchema.append("\n);\n\n");
        for (SchemaField iField : indexFields) {
            tableSchema.append("CREATE INDEX IF NOT EXISTS ").append(table.getName()).append(iField.getName()).append("_IDX ON ").append(table.getName());
            tableSchema.append(" (").append(iField.getName()).append(");\n\n");
        }
        HashMap<String, SchemaTable> alreadyCreatedEnum = new HashMap<String, SchemaTable>();
        SqliteRenderer.generateEnumSchema(tableSchema, table, alreadyCreatedEnum, enumPKField, enumValueField, true);
        return tableSchema.toString();
    }
}

