/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.util;

import java.util.regex.Matcher;

public final class PackageUtil {
    private PackageUtil() {
    }

    public static String getPackageFromFilePath(String filepath) {
        String packageName = filepath.contains("src/main/java") ? PackageUtil.getPackageFromFilePath(filepath, "src.main.java") : (filepath.contains("src\\main\\java") ? PackageUtil.getPackageFromFilePath(filepath, "src.main.java") : (filepath.contains("src/java") ? PackageUtil.getPackageFromFilePath(filepath, "src.java") : (filepath.contains("src\\java") ? PackageUtil.getPackageFromFilePath(filepath, "src.java") : (filepath.contains("src") ? PackageUtil.getPackageFromFilePath(filepath, "src") : PackageUtil.getPackageFromFilePath(filepath, "source")))));
        return packageName;
    }

    public static String getTestBaseDir(String filepath) {
        String testBaseDir = "";
        if (filepath.contains("src/main/java")) {
            testBaseDir = PackageUtil.replaceText(filepath, "src/main/java", "src/test/java");
        } else if (filepath.contains("src\\main\\java")) {
            testBaseDir = PackageUtil.replaceText(filepath, "src\\\\main\\\\java", "src\\test\\java");
        }
        if (filepath.contains("src/java")) {
            testBaseDir = PackageUtil.replaceText(filepath, "src/java", "src/test");
        } else if (filepath.contains("src\\java")) {
            testBaseDir = PackageUtil.replaceText(filepath, "src\\\\java", "src\\test");
        } else if (filepath.contains("src")) {
            testBaseDir = PackageUtil.replaceText(filepath, "src", "test");
        }
        return testBaseDir;
    }

    private static String replaceText(String sourceText, String search, String replace) {
        String replacedText = Matcher.quoteReplacement(sourceText).replaceAll(search, replace);
        return replacedText;
    }

    public static String getPackageFromFilePath(String filepath, String srcDirName) {
        String dotFilepath = "";
        String packageName = "";
        if (filepath == null || filepath.equals("")) {
            return "";
        }
        for (int i = 0; i < filepath.length(); ++i) {
            char c = filepath.charAt(i);
            dotFilepath = c == '\\' || c == '/' ? dotFilepath + '.' : dotFilepath + c;
        }
        int start = dotFilepath.indexOf(srcDirName);
        packageName = start > 0 ? dotFilepath.substring(start + srcDirName.length()) : dotFilepath;
        if (packageName.length() >= 2 && packageName.charAt(1) == ':') {
            packageName = packageName.substring(2);
        }
        if (packageName.length() > 0 && packageName.charAt(0) == '.') {
            packageName = packageName.substring(1);
        }
        if (packageName.length() > 0 && packageName.charAt(packageName.length() - 1) == '.') {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }
}

