/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMLUtil {
    private XMLUtil() {
    }

    public static String getAttribute(Element element, String attributeName, boolean required) {
        return XMLUtil.getAttribute(element, attributeName, required, null);
    }

    public static String getAttribute(Element element, String attributeName, boolean required, String defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        Attribute attr = element.attribute(attributeName);
        if (attr != null) {
            return attr.getValue();
        }
        if (required) {
            throw new IllegalArgumentException("Element Attribute [" + attributeName + "] is a required field!");
        }
        return defaultValue;
    }

    public static boolean getAttributeBoolean(Element element, String attributeName, boolean required, boolean defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static int getAttributeInt(Element element, String attributeName, boolean required, int defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        return defaultValue;
    }

    public static long getAttributeLong(Element element, String attributeName, boolean required, long defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return defaultValue;
    }

    public static float getAttributeFloat(Element element, String attributeName, boolean required, float defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                return 0.0f;
            }
        }
        return defaultValue;
    }

    public static double getAttributeDouble(Element element, String attributeName, boolean required, double defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }
        return defaultValue;
    }

    public static Date getAttributeDate(Element element, String attributeName, boolean required, DateFormat dateformat, Date defaultValue) {
        String value = XMLUtil.getAttribute(element, attributeName, required, null);
        if (value != null) {
            try {
                return dateformat.parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return defaultValue;
    }

    public static Element getElementChild(Element fromElement, String elementName, String elementAttributeName, String elementAttributeValue) {
        Element foundElement = null;
        if (fromElement == null) {
            throw new IllegalArgumentException("fromElement cannot be null");
        }
        Iterator childElements = fromElement.elementIterator(elementName);
        while (childElements.hasNext()) {
            Element childElement = (Element)childElements.next();
            String attrName = XMLUtil.getAttribute(childElement, elementAttributeName, false);
            if (!attrName.equals(elementAttributeValue)) continue;
            foundElement = childElement;
        }
        return foundElement;
    }

    public static String multiLineStringToXmlString(String multiLineString) {
        return XMLUtil.multiLineStringToXmlString(multiLineString, "^");
    }

    public static String multiLineStringToXmlString(String multiLineText, String delimiter) {
        return multiLineText.replace("\n", delimiter);
    }

    public static String xmlStringToMultiLineString(String xmlString) {
        return XMLUtil.xmlStringToMultiLineString(xmlString, "^");
    }

    public static String xmlStringToMultiLineString(String xmlString, String delimiter) {
        return xmlString.replace(delimiter, "\n");
    }
}

