/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.controllers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dd4t.core.resolvers.PublicationResolver;
import org.dd4t.core.services.PropertiesService;
import org.dd4t.core.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBaseController.class);
    @Resource
    protected PublicationResolver publicationResolver;
    @Resource
    protected PropertiesService propertiesService;
    protected boolean removeContextPath = false;

    @PostConstruct
    protected void init() {
        String stripContext = this.propertiesService.getProperty("publication.resolving.strip.context.path", "false");
        if ("true".equalsIgnoreCase(stripContext) || "false".equalsIgnoreCase(stripContext)) {
            this.removeContextPath = Boolean.valueOf(stripContext);
        } else {
            LOG.warn("{} not set! If a Servlet Context path is present and it should be stripped, this will not be done.", (Object)"publication.resolving.strip.context.path");
        }
    }

    protected static DateFormat createDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(Constants.TIMEZONE_GMT);
        return dateFormat;
    }

    public void setRemoveContextPath(boolean removeContextPath) {
        this.removeContextPath = removeContextPath;
    }

    public boolean removeContextPath() {
        return this.removeContextPath;
    }

    public PublicationResolver getPublicationResolver() {
        return this.publicationResolver;
    }

    public void setPublicationResolver(PublicationResolver publicationResolver) {
        this.publicationResolver = publicationResolver;
    }
}

