/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.controllers;

import java.text.ParseException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.factories.impl.ComponentPresentationFactoryImpl;
import org.dd4t.core.util.TCMURI;
import org.dd4t.mvc.utils.ComponentUtils;
import org.dd4t.mvc.utils.RenderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class AbstractComponentPresentationController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComponentPresentationController.class);
    @Resource
    private ComponentPresentationFactoryImpl componentPresentationFactory;
    private String componentViewPath = "";

    public String showComponentPresentation(@PathVariable String componentViewName, @PathVariable int componentId, HttpServletRequest request) {
        return this.showComponentPresentation(null, componentViewName, componentId, request);
    }

    public String showComponentPresentation(@PathVariable String componentViewPrefix, @PathVariable String componentViewName, @PathVariable int componentId, HttpServletRequest request) {
        LOG.debug(">> {} component with viewPrefix: {}, viewName: {} and componentId: {}", new Object[]{request.getMethod(), componentViewPrefix, componentViewName, componentId});
        ComponentPresentation componentPresentation = ComponentUtils.getComponentPresentation(request);
        if ((componentPresentation == null || componentPresentation.isDynamic()) && componentPresentation != null) {
            try {
                TCMURI ctUri = new TCMURI(componentPresentation.getComponentTemplate().getId());
                componentPresentation = this.componentPresentationFactory.getComponentPresentation(new TCMURI(ctUri.getPublicationId(), componentId, 16, 0).toString(), componentPresentation.getComponentTemplate().getId());
            }
            catch (ParseException | FactoryException e) {
                LOG.error(e.getLocalizedMessage(), e);
            }
        }
        if (componentPresentation == null) {
            throw new ResourceNotFoundException();
        }
        RenderUtils.setDynamicComponentOnRequest(request, componentPresentation.getComponent());
        RenderUtils.setViewModelsOnRequest(request, componentPresentation);
        LOG.debug("Rendering component presentation with template '{}' and component id '{}'", (Object)componentViewName, (Object)componentId);
        if (StringUtils.isNotEmpty((CharSequence)componentViewPrefix)) {
            return this.getComponentViewName(componentViewPrefix + "/" + componentViewName);
        }
        return this.getComponentViewName(componentViewName);
    }

    private String getComponentViewName(String tridionName) {
        return RenderUtils.fixUrl(this.getComponentViewPath() + tridionName.trim());
    }

    public String getComponentViewPath() {
        return this.componentViewPath;
    }

    public void setComponentViewPath(String componentViewPath) {
        this.componentViewPath = componentViewPath;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public static class ResourceNotFoundException
    extends RuntimeException {
    }
}

