/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.tags;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Page;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.mvc.utils.RenderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseComponentPresentationsTag
extends SimpleTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BaseComponentPresentationsTag.class);
    private static final String ANCHOR_FORMAT = "<a name=\"%d\"></a>%n";
    private String schema;
    private String rootElement;
    private String view;
    private Boolean addAnchor = false;
    private Integer start;
    private Integer end;
    private String region;

    public int getAnchorCount(HttpServletRequest request) {
        int counter = 0;
        if (null != request.getAttribute("anchorCounter")) {
            counter = (Integer)request.getAttribute("anchorCounter") + 1;
        }
        request.setAttribute("anchorCounter", (Object)counter);
        return counter;
    }

    protected abstract List<ComponentPresentation> getComponentPresentations(Page var1);

    public void doTag() throws JspException, IOException {
        Page page = (Page)this.getJspContext().getAttribute("pageModel", 2);
        if (page != null) {
            PageContext pageContext = (PageContext)this.getJspContext();
            List<ComponentPresentation> filteredComponentPresentations = RenderUtils.filterComponentPresentations(this.getComponentPresentations(page), this.getSchema(), this.getRootElement(), this.getView(), this.getRegion());
            String out = "";
            if (this.start != null || this.end != null) {
                int endPos;
                int size = filteredComponentPresentations.size();
                int startPos = this.start != null ? this.start : 0;
                int n = endPos = this.end != null ? this.end : size;
                if (startPos <= endPos && startPos <= size && endPos <= size) {
                    filteredComponentPresentations = filteredComponentPresentations.subList(startPos, endPos);
                } else {
                    LOG.error("start {} and end {} filtering incorrect for number of component presentations ({}) on page {}", (Object)size, (Object)page.getId());
                }
            }
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            try {
                out = RenderUtils.renderComponentPresentations(request, response, filteredComponentPresentations);
            }
            catch (FactoryException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
            if (this.addAnchor.booleanValue()) {
                pageContext.getOut().write(String.format(ANCHOR_FORMAT, this.getAnchorCount(request)) + out);
            } else {
                pageContext.getOut().write(out);
            }
        } else {
            LOG.warn("The JSP context does not contain an attribute called 'pageModel'.");
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Boolean isAddAnchor() {
        return this.addAnchor;
    }

    public void setAddAnchor(Boolean addAnchor) {
        this.addAnchor = addAnchor;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

