/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.tags;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.dd4t.contentmodel.Page;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.mvc.utils.RenderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderDynamicComponentPresentationTag
extends SimpleTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RenderDynamicComponentPresentationTag.class);
    private String componentURI;
    private String templateURI;
    private String viewName;

    public void doTag() throws JspException, IOException {
        Page page = (Page)this.getJspContext().getAttribute("pageModel", 2);
        if (page != null) {
            PageContext pageContext = (PageContext)this.getJspContext();
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            String renderedCp = "";
            try {
                renderedCp = RenderUtils.renderDynamicComponentPresentation(request, response, this.componentURI, this.templateURI, this.viewName);
            }
            catch (FactoryException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
            pageContext.getOut().write(renderedCp);
        } else {
            LOG.warn("The JSP context does not contain an attribute called 'pageModel'.");
        }
    }

    public String getComponentURI() {
        return this.componentURI;
    }

    public void setComponentURI(String componentURI) {
        this.componentURI = componentURI;
    }

    public String getTemplateURI() {
        return this.templateURI;
    }

    public void setTemplateURI(String templateURI) {
        this.templateURI = templateURI;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

