/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.tags;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.core.databind.TridionViewModel;
import org.dd4t.mvc.utils.XPMRenderer;

public class XPMComponentFieldTag
extends BodyTagSupport {
    private static final long serialVersionUID = -572209173487510785L;
    private transient TridionViewModel model;
    private String field;
    private int index;
    private String enclosed = "span";
    private Boolean useEnclosingTags = true;

    public int doAfterBody() throws JspException {
        XPMRenderer factory = XPMRenderer.getInstance();
        BodyContent content = this.getBodyContent();
        StringBuilder out = new StringBuilder();
        if (XPMRenderer.isXPMEnabled()) {
            if (this.model == null) {
                return 0;
            }
            String xpath = this.model.getXPath(this.field);
            boolean isMultiValued = this.model.isMultiValued(this.field);
            if (StringUtils.isNotEmpty((CharSequence)this.enclosed) && this.useEnclosingTags.booleanValue()) {
                out.append(String.format("<%s>", this.enclosed));
            }
            out.append(factory.componentField(xpath, isMultiValued, this.index));
            out.append(content.getString());
            if (StringUtils.isNotEmpty((CharSequence)this.enclosed) && this.useEnclosingTags.booleanValue()) {
                out.append(String.format("</%s>", this.enclosed));
            }
        } else {
            out.append(content.getString());
        }
        JspWriter writer = null;
        try {
            writer = content.getEnclosingWriter();
            writer.write(out.toString());
        }
        catch (IOException e) {
            throw new JspException("Failed to write body content", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return 0;
    }

    public TridionViewModel getModel() {
        return this.model;
    }

    public void setModel(TridionViewModel model) {
        this.model = model;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getEnclosed() {
        return this.enclosed;
    }

    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    public Boolean isUseEnclosingTags() {
        return this.useEnclosingTags;
    }

    public void setUseEnclosingTags(Boolean useEnclosingTags) {
        this.useEnclosingTags = useEnclosingTags;
    }
}

