/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.utils;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.core.databind.BaseViewModel;
import org.dd4t.core.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtils {
    private static final String COMPONENT_PRESENTATION_NAME = "componentPresentation";
    private static final Logger LOG = LoggerFactory.getLogger(ComponentUtils.class);

    private ComponentUtils() {
    }

    public static ComponentPresentation getComponentPresentation(HttpServletRequest request) {
        return (ComponentPresentation)request.getAttribute(COMPONENT_PRESENTATION_NAME);
    }

    public static void setComponentPresentation(HttpServletRequest request, ComponentPresentation componentPresentation) {
        request.setAttribute(COMPONENT_PRESENTATION_NAME, (Object)componentPresentation);
        LOG.debug("Added Component Presentation with Component id {} and rootElementName '{}' to the request.", (Object)componentPresentation.getComponent().getId(), (Object)componentPresentation.getComponent().getSchema().getRootElement());
    }

    public static void removeComponentPresentation(HttpServletRequest request) {
        request.removeAttribute(COMPONENT_PRESENTATION_NAME);
    }

    public static Map<String, BaseViewModel> getViewModels(HttpServletRequest request) {
        ComponentPresentation componentPresentation = (ComponentPresentation)request.getAttribute(COMPONENT_PRESENTATION_NAME);
        if (componentPresentation != null) {
            return componentPresentation.getAllViewModels();
        }
        return null;
    }

    public static BaseViewModel getViewModel(String modelName) {
        Map<String, BaseViewModel> viewModels = ComponentUtils.getViewModels(HttpUtils.getCurrentRequest());
        if (viewModels != null && !viewModels.isEmpty()) {
            return viewModels.get(modelName);
        }
        return null;
    }

    public static Object getViewModels() {
        return ComponentUtils.getViewModels(HttpUtils.getCurrentRequest());
    }
}

