/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.utils;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.Component;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.ComponentTemplate;
import org.dd4t.contentmodel.Field;
import org.dd4t.core.databind.DataBinder;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.RenderException;
import org.dd4t.core.factories.ComponentPresentationFactory;
import org.dd4t.core.util.TCMURI;
import org.dd4t.mvc.utils.ApplicationContextProvider;
import org.dd4t.mvc.utils.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RenderUtils.class);

    private RenderUtils() {
    }

    public static String getViewName(ComponentPresentation cp) throws IOException {
        ComponentTemplate componentTemplate = cp.getComponentTemplate();
        DataBinder databinder = (DataBinder)ApplicationContextProvider.getBean(DataBinder.class);
        String viewNameKey = databinder.findComponentTemplateViewName(componentTemplate);
        if (StringUtils.isNotEmpty((CharSequence)viewNameKey)) {
            return viewNameKey;
        }
        return componentTemplate.getTitle().toLowerCase();
    }

    public static List<ComponentPresentation> filterComponentPresentations(List<ComponentPresentation> componentPresentations, String schemaName, String rootElementName, String viewName, String region) throws IOException {
        boolean regionIsSet = false;
        if (region != null) {
            regionIsSet = true;
            LOG.debug("Fetching component presentations for region: {}", (Object)region);
        } else {
            LOG.debug("Component Presentations By Region is called, but no region is set.");
            LOG.debug("Removing component presentations which do have a region set.");
        }
        ArrayList<ComponentPresentation> componentPresentationsToRender = new ArrayList<ComponentPresentation>();
        if (StringUtils.isNotEmpty((CharSequence)schemaName) || StringUtils.isNotEmpty((CharSequence)rootElementName) || StringUtils.isNotEmpty((CharSequence)viewName)) {
            for (ComponentPresentation cp : componentPresentations) {
                String componentSchema = cp.getComponent().getSchema().getTitle();
                String componentRootElement = cp.getComponent().getSchema().getRootElement();
                String view = RenderUtils.getViewName(cp);
                if (!RenderUtils.match(componentSchema.toLowerCase(), schemaName) || !RenderUtils.match(componentRootElement, rootElementName) || !RenderUtils.match(view, viewName) || !RenderUtils.isComponentPresentationInRegion(region, regionIsSet, cp)) continue;
                componentPresentationsToRender.add(cp);
            }
        } else {
            for (ComponentPresentation cp : componentPresentations) {
                if (!RenderUtils.isComponentPresentationInRegion(region, regionIsSet, cp)) continue;
                componentPresentationsToRender.add(cp);
            }
        }
        return componentPresentationsToRender;
    }

    private static boolean isComponentPresentationInRegion(String region, boolean regionIsSet, ComponentPresentation cp) {
        Field currentRegion;
        Map metadata = cp.getComponentTemplate().getMetadata();
        Field field = currentRegion = metadata != null ? (Field)metadata.get("region") : null;
        if (currentRegion != null && currentRegion.getValues() != null && !currentRegion.getValues().isEmpty()) {
            if (regionIsSet) {
                boolean removeCp = true;
                for (Object regionValue : currentRegion.getValues()) {
                    if (!regionValue.toString().equalsIgnoreCase(region)) continue;
                    LOG.debug("CP Region matches configured region: {}", (Object)regionValue.toString());
                    removeCp = false;
                }
                if (removeCp) {
                    LOG.debug("No matching region found. Not Rendering.");
                    return false;
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("This is a CP with a Region, but there is no region configured on the Tag.");
                LOG.debug("Not rendering CP: {}-{}", (Object)cp.getComponent().getId(), (Object)cp.getComponentTemplate().getId());
                for (Object regionValue : currentRegion.getValues()) {
                    LOG.debug("With Region: {}", (Object)regionValue.toString());
                }
            }
            return false;
        }
        LOG.debug("No Region set on CP: {} - {}", (Object)(cp.getComponent() != null ? cp.getComponent().getId() : "null"), (Object)cp.getComponentTemplate().getId());
        if (regionIsSet) {
            LOG.debug("Not rendering this CP as a region is set on the Tag.");
            return false;
        }
        LOG.debug("Rendering as no region is set on either the Tag or the CP");
        return true;
    }

    private static boolean match(String value, String expressionParam) {
        Boolean matchFound;
        if (StringUtils.isEmpty((CharSequence)expressionParam)) {
            return true;
        }
        String expression = expressionParam.trim();
        boolean inverseMatching = expression.startsWith("!");
        expression = inverseMatching ? expression.substring(1).trim() : expression;
        String[] expressionParts = expression.split(",");
        if (inverseMatching) {
            matchFound = true;
            for (String exprPart : expressionParts) {
                if (!value.equals(exprPart.trim())) continue;
                matchFound = false;
            }
        } else {
            matchFound = false;
            for (String exprPart : expressionParts) {
                if (!value.equals(exprPart.trim())) continue;
                matchFound = true;
            }
        }
        return matchFound;
    }

    public static String fixUrl(String url) {
        return url.replace(' ', '-').toLowerCase();
    }

    public static String renderComponentPresentations(HttpServletRequest request, HttpServletResponse response, List<ComponentPresentation> componentPresentations) throws FactoryException, IOException {
        StringBuilder output = new StringBuilder();
        if (componentPresentations == null) {
            return output.toString();
        }
        for (ComponentPresentation cp : componentPresentations) {
            output.append(RenderUtils.renderComponentPresentation(request, response, cp));
        }
        return output.toString();
    }

    public static String renderComponentPresentation(HttpServletRequest request, HttpServletResponse response, ComponentPresentation cp) throws FactoryException, IOException {
        return RenderUtils.getResponse(request, response, cp, RenderUtils.getViewName(cp));
    }

    public static String renderDynamicComponentPresentation(HttpServletRequest request, HttpServletResponse response, String componentURI, String templateURI, String viewName) throws FactoryException {
        ComponentPresentationFactory cpf = (ComponentPresentationFactory)ApplicationContextProvider.getBean(ComponentPresentationFactory.class);
        ComponentPresentation componentPresentation = cpf.getComponentPresentation(componentURI, templateURI);
        return RenderUtils.getResponse(request, response, componentPresentation, viewName);
    }

    public static String dispatchBufferedRequest(HttpServletRequest request, HttpServletResponse response, String url) throws ServletException, IOException {
        long time = System.currentTimeMillis();
        RequestDispatcher dispatcher = request.getServletContext().getRequestDispatcher(url);
        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(response){
            private CharArrayWriter output = new CharArrayWriter();

            public String toString() {
                return this.output.toString();
            }

            public PrintWriter getWriter() {
                return new PrintWriter(this.output);
            }
        };
        dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
        time = System.currentTimeMillis() - time;
        LOG.debug("dispatchBufferedRequest {}, takes: {} ms.", (Object)url, (Object)time);
        return responseWrapper.toString();
    }

    private static String getResponse(HttpServletRequest request, HttpServletResponse response, ComponentPresentation cp, String viewName) throws FactoryException {
        try {
            TCMURI tcmuri = new TCMURI(cp.getComponent().getId());
            ComponentUtils.setComponentPresentation(request, cp);
            request.setAttribute("componentTemplateId", (Object)cp.getComponentTemplate().getId());
            request.setAttribute("dynamicComponentPresentation", (Object)cp.isDynamic());
            String url = RenderUtils.fixUrl(String.format("/%s/%s.dcp", viewName, tcmuri.getItemId()));
            RenderUtils.setViewModelsOnRequest(request, cp);
            String string = RenderUtils.dispatchBufferedRequest(request, response, url);
            return string;
        }
        catch (IOException | ParseException | ServletException e) {
            LOG.error(e.getMessage(), e);
            throw new RenderException(e);
        }
        finally {
            ComponentUtils.removeComponentPresentation(request);
            RenderUtils.removeViewModelsFromRequest(request);
        }
    }

    public static void removeViewModelsFromRequest(HttpServletRequest request) {
        ComponentPresentation componentPresentation = ComponentUtils.getComponentPresentation(request);
        if (componentPresentation != null && componentPresentation.getAllViewModels() != null) {
            LOG.debug("Removing STM entries");
            for (Map.Entry modelEntry : componentPresentation.getAllViewModels().entrySet()) {
                request.removeAttribute((String)modelEntry.getKey());
            }
        }
    }

    public static void setViewModelsOnRequest(HttpServletRequest request, ComponentPresentation cp) {
        Map viewModels = cp.getAllViewModels();
        if (!viewModels.isEmpty()) {
            for (Map.Entry modelEntry : viewModels.entrySet()) {
                LOG.debug("Adding model with key: {} and type {} to the request stack", modelEntry.getKey(), modelEntry.getValue());
                request.setAttribute((String)modelEntry.getKey(), modelEntry.getValue());
            }
        }
    }

    public static void setDynamicComponentOnRequest(HttpServletRequest request, Component component) {
        request.setAttribute("component", (Object)component);
    }
}

