/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.controllers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.Binary;
import org.dd4t.contentmodel.BinaryData;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.factories.BinaryFactory;
import org.dd4t.core.resolvers.PublicationResolver;
import org.dd4t.core.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;

@Controller
public class AbstractBinaryController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBinaryController.class);
    @Resource
    private PublicationResolver publicationResolver;
    @Resource
    private BinaryFactory binaryFactory;
    private String binaryRootFolder;
    private boolean useBinaryStorage = true;
    private boolean removeContextPath = false;

    public void getBinary(HttpServletRequest request, HttpServletResponse response) throws ItemNotFoundException {
        int publicationId;
        String binaryPath = this.getBinaryPath(request);
        LOG.debug(">> {} binary {}", (Object)request.getMethod(), (Object)binaryPath);
        int resizeToWidth = -1;
        if (request.getParameterMap().containsKey("resizeToWidth")) {
            resizeToWidth = Integer.parseInt(request.getParameter("resizeToWidth"));
        }
        if ((publicationId = this.publicationResolver.discoverPublicationIdByImagesUrl(binaryPath)) == -1) {
            throw new ItemNotFoundException("Could not resolve Publication Id for binary path");
        }
        String path = String.format("%s/%d%s", this.binaryRootFolder, publicationId, binaryPath);
        if (resizeToWidth > -1) {
            path = this.insertIntoPath(path, request.getParameter("resizeToWidth"));
        }
        try {
            Binary binary = this.binaryFactory.getBinaryByURL(binaryPath, publicationId);
            if (binary == null) {
                response.setStatus(HttpStatus.NOT_FOUND.value());
                LOG.error("Item not found:" + binaryPath);
                return;
            }
            String modifiedHeader = request.getHeader("If-Modified-Since");
            if (StringUtils.isNotEmpty((CharSequence)modifiedHeader) && this.createDateFormat().format(binary.getLastPublishedDate().toDate()).equals(modifiedHeader)) {
                response.setStatus(HttpStatus.NOT_MODIFIED.value());
                return;
            }
            this.fillResponse(request, response, binary, path, resizeToWidth);
            IOUtils.closeQuietly((OutputStream)response.getOutputStream());
        }
        catch (IOException | FactoryException e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            LOG.error(e.getMessage(), e);
            throw new ItemNotFoundException(e);
        }
    }

    private String insertIntoPath(String path, String toInsert) {
        int i = path.lastIndexOf(46);
        if (i == 0) {
            LOG.warn("path to binary has no extension: " + path);
            return path;
        }
        return path.substring(0, i + 1) + toInsert + path.substring(i);
    }

    private static String getImageType(String path) {
        int i = path.lastIndexOf(46);
        if (i == 0) {
            LOG.warn("path to binary has no extension: " + path + "; assuming the type is png");
            return "png";
        }
        return path.substring(i + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillResponse(HttpServletRequest request, HttpServletResponse response, Binary binary, String path, int resizeToWidth) throws IOException {
        InputStream content = null;
        try {
            int len;
            long contentLength;
            if (this.isUseBinaryStorage()) {
                File binaryFile = new File(path);
                if (!binaryFile.exists() || binary.getLastPublishedDate().isAfter(binaryFile.lastModified())) {
                    if (resizeToWidth == -1) {
                        AbstractBinaryController.saveBinary(binary, binaryFile);
                    } else {
                        AbstractBinaryController.writeResizedImage(binary, path, resizeToWidth, binaryFile);
                    }
                }
                content = new FileInputStream(binaryFile);
                contentLength = binaryFile.length();
            } else {
                content = binary.getBinaryData().getInputStream();
                contentLength = binary.getBinaryData().getDataSize();
            }
            response.setContentType(this.getContentType(binary, path, request));
            response.setHeader("Content-Length", Long.toString(contentLength));
            response.setHeader("Last-Modified", this.createDateFormat().format(binary.getLastPublishedDate().toDate()));
            response.setStatus(HttpStatus.OK.value());
            byte[] buffer = new byte[response.getBufferSize()];
            while ((len = content.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResizedImage(Binary binary, String path, int resizeToWidth, File binaryFile) throws IOException {
        File tempBinary = new File(path + ".tmp");
        AbstractBinaryController.saveBinary(binary, tempBinary);
        try (FileInputStream content = new FileInputStream(tempBinary);){
            BufferedImage before = ImageIO.read(content);
            int w = before.getWidth();
            int h = before.getHeight();
            if (resizeToWidth > w) {
                LOG.warn("Not resizing image. Resizing to larger formats is unsupported.");
                AbstractBinaryController.saveBinary(binary, binaryFile);
                return;
            }
            float factor = (float)resizeToWidth / (float)w;
            int newH = Math.round(factor * (float)h);
            BufferedImage after = AbstractBinaryController.getScaledInstance(before, resizeToWidth, newH, 2, true);
            ImageIO.write((RenderedImage)after, AbstractBinaryController.getImageType(path), binaryFile);
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            Files.deleteIfExists(tempBinary.toPath());
        }
    }

    private static BufferedImage getScaledInstance(BufferedImage image, int targetWidth, int targetHeight, int type, boolean higherQuality) {
        int h;
        int w;
        BufferedImage ret = image;
        if (higherQuality) {
            w = image.getWidth();
            h = image.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    private String getContentType(Binary binary, String path, HttpServletRequest request) {
        String mimeType = null;
        ServletContext servletContext = request.getSession().getServletContext();
        try {
            mimeType = binary.getMimeType();
            if (mimeType == null) {
                File binaryFile = new File(path);
                mimeType = servletContext.getMimeType(binaryFile.getName());
            }
        }
        catch (Exception e) {
            LOG.error("Error occurred getting mime-type", (Throwable)e);
        }
        if (mimeType == null) {
            LOG.warn("Could not identify mime type for binary file '" + path + "'");
        }
        return mimeType;
    }

    protected String getBinaryPath(HttpServletRequest request) {
        String contextPath;
        String requestURI = request.getRequestURI();
        if (this.removeContextPath && StringUtils.isNotEmpty((CharSequence)(contextPath = request.getContextPath()))) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBinary(Binary binary, File binaryFile) throws IOException {
        FilterOutputStream bufferedOutput = null;
        try {
            BinaryData binaryData;
            byte[] bytes;
            if (!binaryFile.getParentFile().exists()) {
                if (!binaryFile.getParentFile().mkdirs()) {
                    String msg = "Failed to create parent folder(s) for '" + binaryFile.getPath() + "'";
                    LOG.error(msg);
                    throw new IOException(msg);
                }
                LOG.debug("Parent folders created for '{}'", (Object)binaryFile.getPath());
            }
            if ((bytes = (binaryData = binary.getBinaryData()).getBytes()).length > 0) {
                bufferedOutput = new BufferedOutputStream(new FileOutputStream(binaryFile));
                bufferedOutput.write(bytes);
                LOG.debug("Found binary data with length {}", (Object)bytes.length);
            } else {
                LOG.debug("Binary has no bytes, NOT writing to filesystem!");
            }
        }
        finally {
            try {
                if (bufferedOutput != null) {
                    bufferedOutput.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Failed to close output stream!", (Throwable)ex);
            }
        }
        LOG.info("Binary is stored in '{}'", (Object)binaryFile.getPath());
    }

    public void setBinaryRootFolder(String binaryRootFolder) {
        this.binaryRootFolder = binaryRootFolder;
    }

    public boolean isUseBinaryStorage() {
        return this.useBinaryStorage;
    }

    public void setUseBinaryStorage(boolean useBinaryStorage) {
        this.useBinaryStorage = useBinaryStorage;
    }

    public boolean isRemoveContextPath() {
        return this.removeContextPath;
    }

    public void setRemoveContextPath(boolean removeContextPath) {
        this.removeContextPath = removeContextPath;
    }

    void clearBinaryStorage() throws IOException {
        File tempDir = new File(this.binaryRootFolder);
        if (tempDir.exists()) {
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    private DateFormat createDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(Constants.TIMEZONE_GMT);
        return dateFormat;
    }
}

