/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.controllers;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.Field;
import org.dd4t.contentmodel.Page;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.factories.impl.PageFactoryImpl;
import org.dd4t.core.util.Constants;
import org.dd4t.core.util.HttpUtils;
import org.dd4t.mvc.controllers.AbstractBaseController;
import org.dd4t.mvc.utils.RenderUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

@Controller
public abstract class AbstractPageController
extends AbstractBaseController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPageController.class);
    @Resource
    protected PageFactoryImpl pageFactory;
    private String pageViewPath = "";

    public String showPage(Model model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String urlToFetch = HttpUtils.appendDefaultPageIfRequired((String)HttpUtils.getCurrentURL((HttpServletRequest)request, (boolean)this.removeContextPath));
        String url = this.adjustLocalErrorUrl(request, urlToFetch);
        url = HttpUtils.normalizeUrl((String)url);
        LOG.debug(">> {} page {} with dispatcher type {}", new Object[]{request.getMethod(), url, request.getDispatcherType().toString()});
        try {
            if (StringUtils.isEmpty((CharSequence)url)) {
                throw new ItemNotFoundException("Page Url was empty or could not be resolved.");
            }
            Page pageModel = this.pageFactory.findPageByUrl(url, this.publicationResolver.getPublicationId());
            DateTime lastPublishDate = pageModel != null ? pageModel.getLastPublishedDate() : Constants.THE_YEAR_ZERO;
            response.setHeader("Last-Modified", AbstractPageController.createDateFormat().format(lastPublishDate.toDate()));
            model.addAttribute("Referer", (Object)request.getHeader("Referer"));
            model.addAttribute("pageModel", (Object)pageModel);
            model.addAttribute("pageRequestURI", (Object)HttpUtils.appendDefaultPageIfRequired((String)request.getRequestURI()));
            response.setContentType(HttpUtils.getContentTypeByExtension((String)url));
            return this.getPageViewName(pageModel);
        }
        catch (ItemNotFoundException e) {
            LOG.trace(e.getLocalizedMessage(), (Throwable)e);
            LOG.warn("Page with url '{}' could not be found.", (Object)url);
            response.sendError(404);
        }
        catch (FactoryException e) {
            if (e.getCause() instanceof ItemNotFoundException) {
                LOG.warn("Page with url '{}' could not be found.", (Object)url);
                response.sendError(404);
            }
            LOG.error("Factory Error.", (Throwable)e);
            response.sendError(500);
        }
        return null;
    }

    private String adjustLocalErrorUrl(HttpServletRequest request, String url) {
        String adjustedUrl = url;
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            adjustedUrl = this.publicationResolver.getLocalPageUrl(url);
        }
        return adjustedUrl;
    }

    public String getPageViewName(Page page) {
        String viewName = null != page.getPageTemplate().getMetadata() && page.getPageTemplate().getMetadata().containsKey("viewName") ? (String)((Field)page.getPageTemplate().getMetadata().get("viewName")).getValues().get(0) : page.getPageTemplate().getTitle();
        return RenderUtils.fixUrl(this.getPageViewPath() + viewName.trim());
    }

    public String getPageViewPath() {
        return this.pageViewPath;
    }

    public void setPageViewPath(String pageViewPath) {
        this.pageViewPath = pageViewPath;
    }

    public PageFactoryImpl getPageFactory() {
        return this.pageFactory;
    }

    public void setPageFactory(PageFactoryImpl pageFactory) {
        this.pageFactory = pageFactory;
    }
}

