/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.tags;

import java.io.IOException;
import java.net.URL;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.dd4t.core.factories.PageFactory;
import org.dd4t.core.resolvers.PublicationResolver;
import org.dd4t.core.util.HttpUtils;
import org.dd4t.mvc.utils.ApplicationContextProvider;
import org.dd4t.mvc.utils.PublicationResolverFactory;
import org.dd4t.mvc.utils.RenderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartIncludeTag
extends TagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SmartIncludeTag.class);
    private static final long serialVersionUID = 1572096134267964950L;
    private String page;
    private transient PublicationResolver publicationResolver = PublicationResolverFactory.getPublicationResolver();

    public int doStartTag() throws JspException {
        HttpServletRequest currentRequest = (HttpServletRequest)this.pageContext.getRequest();
        if (currentRequest.getDispatcherType() == DispatcherType.INCLUDE || currentRequest.getAttribute("smartIncludeUrl") != null) {
            LOG.debug("Already including.");
            return 0;
        }
        Object includeUrl = this.page;
        PageFactory pageFactory = (PageFactory)ApplicationContextProvider.getBean(PageFactory.class);
        try {
            boolean pageFound;
            int publicationId = this.publicationResolver.getPublicationId();
            String requestUrl = HttpUtils.getOriginalUri((HttpServletRequest)currentRequest);
            URL aUrl = new URL(String.format("http://localhost%s", requestUrl));
            String testPath = aUrl.getPath();
            if (testPath.endsWith(".html") || testPath.endsWith(".xml") || testPath.endsWith(".txt")) {
                testPath = testPath.substring(0, testPath.lastIndexOf("/"));
            }
            if ("/".equals(testPath) && !((String)includeUrl).startsWith("/")) {
                includeUrl = "/" + (String)includeUrl;
            }
            if (((String)includeUrl).startsWith("/")) {
                pageFound = pageFactory.isPagePublished((String)includeUrl, publicationId);
            } else {
                LOG.debug("Current path={}", (Object)testPath);
                String url = String.format("%s/%s", testPath, includeUrl);
                pageFound = pageFactory.isPagePublished(url, publicationId);
                if (pageFound) {
                    includeUrl = url;
                } else {
                    while (testPath.length() > 0 && !pageFound) {
                        if (testPath.length() > 1) {
                            testPath = testPath.substring(0, testPath.lastIndexOf("/"));
                        }
                        url = String.format("%s/%s", testPath, includeUrl);
                        LOG.debug("Testing URL {}", (Object)url);
                        if (!pageFactory.isPagePublished(url, publicationId).booleanValue()) continue;
                        pageFound = true;
                        includeUrl = url;
                    }
                }
            }
            if (!pageFound) {
                return 0;
            }
            this.includePage(currentRequest, (String)includeUrl);
        }
        catch (IOException | ServletException e) {
            LOG.error(e.getMessage(), e);
            throw new JspException(e);
        }
        return 0;
    }

    private void includePage(HttpServletRequest currentRequest, String includeUrl) throws ServletException, IOException {
        this.pageContext.getRequest().setAttribute("smartIncludeUrl", (Object)includeUrl);
        LOG.debug(">> Including: {}", (Object)includeUrl);
        String renderedInclude = RenderUtils.dispatchBufferedRequest(currentRequest, (HttpServletResponse)this.pageContext.getResponse(), includeUrl);
        this.pageContext.getOut().print(renderedInclude);
        currentRequest.setAttribute("smartIncludeUrl", null);
        LOG.debug("<< End including {}", (Object)includeUrl);
    }

    public int doEndTag() throws JspException {
        return 0;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }
}

