/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.utils;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.dd4t.core.util.HttpUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;

public final class JspBeanContext {
    private JspBeanContext() {
    }

    public static <T> T getBean(Class<T> type) {
        return (T)JspBeanContext.getWebApplicationContext().getBean(type);
    }

    public static Object getBean(String beanName) {
        return JspBeanContext.getWebApplicationContext().getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> type) {
        return (T)JspBeanContext.getWebApplicationContext().getBean(beanName, type);
    }

    private static WebApplicationContext getWebApplicationContext() {
        return JspBeanContext.findWebApplicationContext(HttpUtils.getCurrentRequest(), null);
    }

    public static WebApplicationContext findWebApplicationContext(HttpServletRequest request, ServletContext servletContext) {
        WebApplicationContext webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext != null) {
                webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            }
            if (webApplicationContext == null) {
                webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
            }
        }
        return webApplicationContext;
    }
}

