/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.dd4t.mvc.utils.PropertiesServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class PropertiesServiceImpl
extends PropertiesServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String propertiesFile) {
        LOG.debug("Loading file " + propertiesFile);
        InputStream input = null;
        try {
            input = PropertiesServiceImpl.class.getClassLoader().getResourceAsStream(propertiesFile);
            if (input == null) {
                throw new IOException("Cannot find properties file '" + propertiesFile + "' in classpath");
            }
            this.properties = new Properties();
            this.properties.load(input);
        }
        catch (IOException ioe) {
            try {
                LOG.error("Failed to load properties file " + propertiesFile, (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    @Required
    public void setLocation(String location) {
        LOG.debug("Load Properties from: {}", (Object)location);
        this.load(location);
    }
}

