/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.mvc.utils;

import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class XPMRenderer {
    private static final XPMRenderer INSTANCE = new XPMRenderer();
    private static final Logger LOG = LoggerFactory.getLogger(XPMRenderer.class);
    public static final String XPM_BOOTSTRAP_PATH = "WebUI/Editors/SiteEdit/Views/Bootstrap/Bootstrap.aspx?mode=js";
    private boolean enabled;
    private String cmsURL;

    private XPMRenderer() {
    }

    public static XPMRenderer getInstance() {
        return INSTANCE;
    }

    public static boolean isXPMEnabled() {
        return XPMRenderer.INSTANCE.enabled;
    }

    public static boolean isXPMActive() {
        return XPMRenderer.isXPMEnabled();
    }

    public void init(boolean enabled, String cmsURL) {
        this.enabled = enabled;
        this.cmsURL = cmsURL;
    }

    private static String stripTypeIdentifier(String componentId) {
        if (componentId.endsWith("-16")) {
            return componentId.substring(0, componentId.length() - 3);
        }
        return componentId;
    }

    public String componentPresentation(String componentId, DateTime lastModified, String componentTemplateId, boolean isDynamic) {
        if (XPMRenderer.isXPMEnabled()) {
            return "<!-- Start Component Presentation: {\n\"ComponentID\": \"" + XPMRenderer.stripTypeIdentifier(componentId) + "\",\n\"ComponentModified\": \"" + this.getXMLDateAsString(lastModified) + "\",\n\"ComponentTemplateID\": \"" + componentTemplateId + "\",\n\"IsRepositoryPublished\": " + isDynamic + "\n} -->";
        }
        return "";
    }

    public String region(String title, Map<String, String> allowedComponentTypes, int minOccurs, int maxOccurs) {
        if (XPMRenderer.isXPMEnabled()) {
            return "<!-- Start Region: {\n\"title\": \"" + title + "\",\n\"allowedComponentTypes\": " + this.formatAllowedComponentTypes(allowedComponentTypes) + ",\n\"minOccurs\": " + minOccurs + ",\n\"maxOccurs\": " + maxOccurs + "\n} -->";
        }
        return "";
    }

    public String componentField(String xPath, boolean multiValued, int index) {
        if (XPMRenderer.isXPMEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<!-- Start Component Field: {\n");
            if (xPath.endsWith("]")) {
                stringBuilder.append(String.format("\"XPath\": \"%s\"", xPath));
            } else {
                if (index == 0) {
                    index = 1;
                }
                stringBuilder.append(String.format("\"XPath\": \"%s[%d]\"", xPath, index));
            }
            if (multiValued) {
                stringBuilder.append(",\n\"IsMultiValued\": true");
            }
            stringBuilder.append("\n} -->");
            return stringBuilder.toString();
        }
        return "";
    }

    public String initPage(String pageId, DateTime revisionDate, String pageTemplateId) {
        if (XPMRenderer.isXPMEnabled()) {
            return "<!-- Page Settings: {\n\"PageID\": \"" + pageId + "\",\n\"PageModified\": \"" + this.getXMLDateAsString(revisionDate) + "\",\n\"PageTemplateID\": \"" + pageTemplateId + "\"\n} -->\n" + this.getTag();
        }
        return "";
    }

    public String getTag() {
        return "<script type=\"text/javascript\" id=\"tridion.siteedit\" language=\"javascript\" defer=\"defer\" src=\"" + this.cmsURL + "WebUI/Editors/SiteEdit/Views/Bootstrap/Bootstrap.aspx?mode=js\"></script>";
    }

    public String getTagLazyLoaded() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<script>\n");
        stringBuilder.append("(function(doc) {\n");
        stringBuilder.append("setTimeout(function() {\n");
        stringBuilder.append("var script = document.createElement('script');\n");
        stringBuilder.append("script.id = 'tridion.siteedit';\n");
        stringBuilder.append("script.src = '").append(this.cmsURL).append(XPM_BOOTSTRAP_PATH).append("';\n");
        stringBuilder.append("script.async = 1;\n");
        stringBuilder.append("var first = document.getElementsByTagName('script')[0];\n");
        stringBuilder.append("first.parentNode.insertBefore(script, first);\n");
        stringBuilder.append("}, 2000);\n");
        stringBuilder.append("}(document));\n");
        stringBuilder.append("</script>\n");
        return stringBuilder.toString();
    }

    private String formatAllowedComponentTypes(Map<String, String> allowedComponentTypes) {
        String format = "{ \"schema\": \"%s\", \"template\": \"%s\" }";
        if (null != allowedComponentTypes) {
            Object[] allowed = new String[allowedComponentTypes.keySet().size()];
            int i = 0;
            for (Map.Entry<String, String> entry : allowedComponentTypes.entrySet()) {
                allowed[i++] = String.format("{ \"schema\": \"%s\", \"template\": \"%s\" }", entry.getKey(), entry.getValue());
            }
            return Arrays.toString(allowed);
        }
        return "";
    }

    public String getXMLDateAsString(DateTime date) {
        try {
            GregorianCalendar c = date.toGregorianCalendar();
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            xmlDate.setMillisecond(Integer.MIN_VALUE);
            xmlDate.setTimezone(Integer.MIN_VALUE);
            return xmlDate.toXMLFormat();
        }
        catch (DatatypeConfigurationException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    @Required
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Required
    public void setCmsUrl(String cmsURL) {
        this.cmsURL = cmsURL;
    }
}

