/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;

public abstract class AbstractParameterSpace<T>
implements ParameterSpace<T> {
    @Override
    public Map<String, ParameterSpace> getNestedSpaces() {
        LinkedHashMap<String, ParameterSpace> m = new LinkedHashMap<String, ParameterSpace>();
        ArrayList classHeirarchy = new ArrayList();
        for (Class<?> currClass = this.getClass(); currClass != Object.class; currClass = currClass.getSuperclass()) {
            classHeirarchy.add(currClass);
        }
        for (int i = classHeirarchy.size() - 1; i >= 0; --i) {
            Field[] allFields;
            for (Field f : allFields = ((Class)classHeirarchy.get(i)).getDeclaredFields()) {
                ParameterSpace p;
                String name = f.getName();
                Class<?> fieldClass = f.getType();
                boolean isParamSpacefield = ParameterSpace.class.isAssignableFrom(fieldClass);
                if (!isParamSpacefield) continue;
                f.setAccessible(true);
                try {
                    p = (ParameterSpace)f.get(this);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (p == null) continue;
                m.put(name, p);
            }
        }
        return m;
    }
}

