/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.TaskCreator;

public class TaskCreatorProvider {
    private static Map<Class<? extends ParameterSpace>, Class<? extends TaskCreator>> map = new HashMap<Class<? extends ParameterSpace>, Class<? extends TaskCreator>>();

    public static synchronized TaskCreator defaultTaskCreatorFor(Class<? extends ParameterSpace> paramSpaceClass) {
        Class<? extends TaskCreator> c = map.get(paramSpaceClass);
        try {
            if (c == null) {
                return null;
            }
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of task creator class: " + c, e);
        }
    }

    public static synchronized void registerDefaultTaskCreatorClass(Class<? extends ParameterSpace> spaceClass, Class<? extends TaskCreator> creatorClass) {
        map.put(spaceClass, creatorClass);
    }
}

