/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api.data;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.nd4j.linalg.dataset.api.iterator.DataSetIteratorFactory;

public class DataSetIteratorFactoryProvider
implements DataProvider {
    public static final String FACTORY_KEY = "org.deeplearning4j.arbiter.data.data.factory";

    public DataSetIteratorFactory trainData(Map<String, Object> dataParameters) {
        return this.create(dataParameters);
    }

    public DataSetIteratorFactory testData(Map<String, Object> dataParameters) {
        return this.create(dataParameters);
    }

    @Override
    public Class<?> getDataType() {
        return DataSetIteratorFactory.class;
    }

    private DataSetIteratorFactory create(Map<String, Object> dataParameters) {
        if (dataParameters == null) {
            throw new IllegalArgumentException("Data parameters is null. Please specify a class name to create a dataset iterator.");
        }
        if (!dataParameters.containsKey(FACTORY_KEY)) {
            throw new IllegalArgumentException("No data set iterator factory class found. Please specify a class name with key org.deeplearning4j.arbiter.data.data.factory");
        }
        String value = dataParameters.get(FACTORY_KEY).toString();
        try {
            Class<?> clazz = Class.forName(value);
            return (DataSetIteratorFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetIteratorFactoryProvider)) {
            return false;
        }
        DataSetIteratorFactoryProvider other = (DataSetIteratorFactoryProvider)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetIteratorFactoryProvider;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "DataSetIteratorFactoryProvider()";
    }
}

