/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api.saving;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver;

public class InMemoryResultSaver
implements ResultSaver {
    @Override
    public ResultReference saveModel(OptimizationResult result, Object modelResult) throws IOException {
        return new InMemoryResult(result, modelResult);
    }

    @Override
    public List<Class<?>> getSupportedCandidateTypes() {
        return Collections.singletonList(Object.class);
    }

    @Override
    public List<Class<?>> getSupportedModelTypes() {
        return Collections.singletonList(Object.class);
    }

    private static class InMemoryResult
    implements ResultReference {
        private OptimizationResult result;
        private Object modelResult;

        @Override
        public OptimizationResult getResult() throws IOException {
            return this.result;
        }

        @Override
        public Object getResultModel() throws IOException {
            return this.modelResult;
        }

        public InMemoryResult(OptimizationResult result, Object modelResult) {
            this.result = result;
            this.modelResult = modelResult;
        }
    }
}

