/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api.termination;

import org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition;
import org.deeplearning4j.arbiter.optimize.runner.IOptimizationRunner;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MaxCandidatesCondition
implements TerminationCondition {
    @JsonProperty
    private int maxCandidates;

    @Override
    public void initialize(IOptimizationRunner optimizationRunner) {
    }

    @Override
    public boolean terminate(IOptimizationRunner optimizationRunner) {
        return optimizationRunner.numCandidatesCompleted() + optimizationRunner.numCandidatesFailed() >= this.maxCandidates;
    }

    public String toString() {
        return "MaxCandidatesCondition(" + this.maxCandidates + ")";
    }

    public MaxCandidatesCondition(int maxCandidates) {
        this.maxCandidates = maxCandidates;
    }

    public MaxCandidatesCondition() {
    }

    public int getMaxCandidates() {
        return this.maxCandidates;
    }

    public void setMaxCandidates(int maxCandidates) {
        this.maxCandidates = maxCandidates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxCandidatesCondition)) {
            return false;
        }
        MaxCandidatesCondition other = (MaxCandidatesCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMaxCandidates() == other.getMaxCandidates();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxCandidatesCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxCandidates();
        return result;
    }
}

