/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.api.termination;

import java.util.concurrent.TimeUnit;
import org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition;
import org.deeplearning4j.arbiter.optimize.runner.IOptimizationRunner;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MaxTimeCondition
implements TerminationCondition {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd-MMM HH:mm ZZ");
    private long duration;
    private TimeUnit timeUnit;
    private long startTime;
    private long endTime;

    private MaxTimeCondition(@JsonProperty(value="duration") long duration, @JsonProperty(value="timeUnit") TimeUnit timeUnit, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="endTime") long endTime) {
        this.duration = duration;
        this.timeUnit = timeUnit;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public MaxTimeCondition(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    @Override
    public void initialize(IOptimizationRunner optimizationRunner) {
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + this.timeUnit.toMillis(this.duration);
    }

    @Override
    public boolean terminate(IOptimizationRunner optimizationRunner) {
        return System.currentTimeMillis() >= this.endTime;
    }

    public String toString() {
        if (this.startTime > 0L) {
            return "MaxTimeCondition(" + this.duration + "," + (Object)((Object)this.timeUnit) + ",start=\"" + formatter.print(this.startTime) + "\",end=\"" + formatter.print(this.endTime) + "\")";
        }
        return "MaxTimeCondition(" + this.duration + "," + (Object)((Object)this.timeUnit) + "\")";
    }

    public MaxTimeCondition() {
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxTimeCondition)) {
            return false;
        }
        MaxTimeCondition other = (MaxTimeCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        return this.getEndTime() == other.getEndTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxTimeCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        return result;
    }
}

