/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.deeplearning4j.arbiter.optimize.api.CandidateGenerator;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.data.DataSource;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition;
import org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class OptimizationConfiguration {
    @JsonSerialize
    private DataProvider dataProvider;
    @JsonSerialize
    private Class<? extends DataSource> dataSource;
    @JsonSerialize
    private Properties dataSourceProperties;
    @JsonSerialize
    private CandidateGenerator candidateGenerator;
    @JsonSerialize
    private ResultSaver resultSaver;
    @JsonSerialize
    private ScoreFunction scoreFunction;
    @JsonSerialize
    private List<TerminationCondition> terminationConditions;
    @JsonSerialize
    private Long rngSeed;
    private long executionStartTime;

    private OptimizationConfiguration(Builder builder) {
        this.dataProvider = builder.dataProvider;
        this.dataSource = builder.dataSource;
        this.dataSourceProperties = builder.dataSourceProperties;
        this.candidateGenerator = builder.candidateGenerator;
        this.resultSaver = builder.resultSaver;
        this.scoreFunction = builder.scoreFunction;
        this.terminationConditions = builder.terminationConditions;
        this.rngSeed = builder.rngSeed;
        if (this.rngSeed != null) {
            this.candidateGenerator.setRngSeed(this.rngSeed);
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Data source class " + this.dataSource.getName() + " does not have a public no-argument constructor");
            }
        }
    }

    public static OptimizationConfiguration fromYaml(String json) {
        try {
            return (OptimizationConfiguration)JsonMapper.getYamlMapper().readValue(json, OptimizationConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OptimizationConfiguration fromJson(String json) {
        try {
            return (OptimizationConfiguration)JsonMapper.getMapper().readValue(json, OptimizationConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        try {
            return JsonMapper.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return JsonMapper.getYamlMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public Class<? extends DataSource> getDataSource() {
        return this.dataSource;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public CandidateGenerator getCandidateGenerator() {
        return this.candidateGenerator;
    }

    public ResultSaver getResultSaver() {
        return this.resultSaver;
    }

    public ScoreFunction getScoreFunction() {
        return this.scoreFunction;
    }

    public List<TerminationCondition> getTerminationConditions() {
        return this.terminationConditions;
    }

    public Long getRngSeed() {
        return this.rngSeed;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setDataSource(Class<? extends DataSource> dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourceProperties(Properties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public void setCandidateGenerator(CandidateGenerator candidateGenerator) {
        this.candidateGenerator = candidateGenerator;
    }

    public void setResultSaver(ResultSaver resultSaver) {
        this.resultSaver = resultSaver;
    }

    public void setScoreFunction(ScoreFunction scoreFunction) {
        this.scoreFunction = scoreFunction;
    }

    public void setTerminationConditions(List<TerminationCondition> terminationConditions) {
        this.terminationConditions = terminationConditions;
    }

    public void setRngSeed(Long rngSeed) {
        this.rngSeed = rngSeed;
    }

    public String toString() {
        return "OptimizationConfiguration(dataProvider=" + this.getDataProvider() + ", dataSource=" + this.getDataSource() + ", dataSourceProperties=" + this.getDataSourceProperties() + ", candidateGenerator=" + this.getCandidateGenerator() + ", resultSaver=" + this.getResultSaver() + ", scoreFunction=" + this.getScoreFunction() + ", terminationConditions=" + this.getTerminationConditions() + ", rngSeed=" + this.getRngSeed() + ", executionStartTime=" + this.getExecutionStartTime() + ")";
    }

    public OptimizationConfiguration() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizationConfiguration)) {
            return false;
        }
        OptimizationConfiguration other = (OptimizationConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends DataSource> this$dataSource = this.getDataSource();
        Class<? extends DataSource> other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        Properties this$dataSourceProperties = this.getDataSourceProperties();
        Properties other$dataSourceProperties = other.getDataSourceProperties();
        if (this$dataSourceProperties == null ? other$dataSourceProperties != null : !((Object)this$dataSourceProperties).equals(other$dataSourceProperties)) {
            return false;
        }
        ScoreFunction this$scoreFunction = this.getScoreFunction();
        ScoreFunction other$scoreFunction = other.getScoreFunction();
        if (this$scoreFunction == null ? other$scoreFunction != null : !this$scoreFunction.equals(other$scoreFunction)) {
            return false;
        }
        Long this$rngSeed = this.getRngSeed();
        Long other$rngSeed = other.getRngSeed();
        if (this$rngSeed == null ? other$rngSeed != null : !((Object)this$rngSeed).equals(other$rngSeed)) {
            return false;
        }
        return this.getExecutionStartTime() == other.getExecutionStartTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizationConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends DataSource> $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        Properties $dataSourceProperties = this.getDataSourceProperties();
        result = result * 59 + ($dataSourceProperties == null ? 43 : ((Object)$dataSourceProperties).hashCode());
        ScoreFunction $scoreFunction = this.getScoreFunction();
        result = result * 59 + ($scoreFunction == null ? 43 : $scoreFunction.hashCode());
        Long $rngSeed = this.getRngSeed();
        result = result * 59 + ($rngSeed == null ? 43 : ((Object)$rngSeed).hashCode());
        long $executionStartTime = this.getExecutionStartTime();
        result = result * 59 + (int)($executionStartTime >>> 32 ^ $executionStartTime);
        return result;
    }

    public long getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(long executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public static class Builder {
        private DataProvider dataProvider;
        private Class<? extends DataSource> dataSource;
        private Properties dataSourceProperties;
        private CandidateGenerator candidateGenerator;
        private ResultSaver resultSaver;
        private ScoreFunction scoreFunction;
        private List<TerminationCondition> terminationConditions;
        private Long rngSeed;

        @Deprecated
        public Builder dataProvider(DataProvider dataProvider) {
            this.dataProvider = dataProvider;
            return this;
        }

        public Builder dataSource(Class<? extends DataSource> dataSource, Properties dataSourceProperties) {
            this.dataSource = dataSource;
            this.dataSourceProperties = dataSourceProperties;
            return this;
        }

        public Builder candidateGenerator(CandidateGenerator candidateGenerator) {
            this.candidateGenerator = candidateGenerator;
            return this;
        }

        public Builder modelSaver(ResultSaver resultSaver) {
            this.resultSaver = resultSaver;
            return this;
        }

        public Builder scoreFunction(ScoreFunction scoreFunction) {
            this.scoreFunction = scoreFunction;
            return this;
        }

        public Builder terminationConditions(TerminationCondition ... conditions) {
            this.terminationConditions = Arrays.asList(conditions);
            return this;
        }

        public Builder terminationConditions(List<TerminationCondition> terminationConditions) {
            this.terminationConditions = terminationConditions;
            return this;
        }

        public Builder rngSeed(long rngSeed) {
            this.rngSeed = rngSeed;
            return this;
        }

        public OptimizationConfiguration build() {
            return new OptimizationConfiguration(this);
        }
    }
}

