/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.distribution;

import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;

public class DegenerateIntegerDistribution
implements IntegerDistribution {
    private int value;

    public DegenerateIntegerDistribution(int value) {
        this.value = value;
    }

    public double probability(int x) {
        return x == this.value ? 1.0 : 0.0;
    }

    public double cumulativeProbability(int x) {
        return x >= this.value ? 1.0 : 0.0;
    }

    public double cumulativeProbability(int x0, int x1) throws NumberIsTooLargeException {
        return this.value >= x0 && this.value <= x1 ? 1.0 : 0.0;
    }

    public int inverseCumulativeProbability(double p) throws OutOfRangeException {
        throw new UnsupportedOperationException();
    }

    public double getNumericalMean() {
        return this.value;
    }

    public double getNumericalVariance() {
        return 0.0;
    }

    public int getSupportLowerBound() {
        return this.value;
    }

    public int getSupportUpperBound() {
        return this.value;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public void reseedRandomGenerator(long seed) {
    }

    public int sample() {
        return this.value;
    }

    public int[] sample(int sampleSize) {
        int[] out = new int[sampleSize];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.value;
        }
        return out;
    }
}

