/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.distribution;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;

public class LogUniformDistribution
implements RealDistribution {
    private final double min;
    private final double max;
    private final double logMin;
    private final double logMax;
    private transient Random rng = new Random();

    public LogUniformDistribution(double min, double max) {
        Preconditions.checkArgument((min > 0.0 ? 1 : 0) != 0, (Object)("Minimum must be > 0. Got: " + min));
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (Object)("Maximum must be > min. Got: (min, max)=(" + min + "," + max + ")"));
        this.min = min;
        this.max = max;
        this.logMin = Math.log(min);
        this.logMax = Math.log(max);
    }

    public double probability(double x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        return 1.0 / (x * (this.logMax - this.logMin));
    }

    public double density(double x) {
        return this.probability(x);
    }

    public double cumulativeProbability(double x) {
        if (x <= this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        return (Math.log(x) - this.logMin) / (this.logMax - this.logMin);
    }

    public double cumulativeProbability(double x0, double x1) throws NumberIsTooLargeException {
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (Object)("Invalid input: " + p));
        return Math.exp(p * (this.logMax - this.logMin) + this.logMin);
    }

    public double getNumericalMean() {
        return (this.max - this.min) / (this.logMax - this.logMin);
    }

    public double getNumericalVariance() {
        double d1 = (this.logMax - this.logMin) * (this.max * this.max - this.min * this.min) - 2.0 * (this.max - this.min) * (this.max - this.min);
        return d1 / (2.0 * Math.pow(this.logMax - this.logMin, 2.0));
    }

    public double getSupportLowerBound() {
        return this.min;
    }

    public double getSupportUpperBound() {
        return this.max;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public void reseedRandomGenerator(long seed) {
        this.rng.setSeed(seed);
    }

    public double sample() {
        return this.inverseCumulativeProbability(this.rng.nextDouble());
    }

    public double[] sample(int sampleSize) {
        double[] d = new double[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            d[i] = this.sample();
        }
        return d;
    }

    public String toString() {
        return "LogUniformDistribution(min=" + this.min + ",max=" + this.max + ")";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

