/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.generator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.deeplearning4j.arbiter.optimize.api.CandidateGenerator;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.util.LeafUtils;

public abstract class BaseCandidateGenerator<T>
implements CandidateGenerator {
    protected ParameterSpace<T> parameterSpace;
    protected AtomicInteger candidateCounter = new AtomicInteger(0);
    protected SynchronizedRandomGenerator rng = new SynchronizedRandomGenerator((RandomGenerator)new JDKRandomGenerator());
    protected Map<String, Object> dataParameters;
    protected boolean initDone = false;

    public BaseCandidateGenerator(ParameterSpace<T> parameterSpace, Map<String, Object> dataParameters, boolean initDone) {
        this.parameterSpace = parameterSpace;
        this.dataParameters = dataParameters;
        this.initDone = initDone;
    }

    protected void initialize() {
        if (!this.initDone) {
            List<ParameterSpace> noDuplicatesList = LeafUtils.getUniqueObjects(this.parameterSpace.collectLeaves());
            int i = 0;
            for (ParameterSpace ps : noDuplicatesList) {
                int np = ps.numParameters();
                if (np == 1) {
                    ps.setIndices(i++);
                    continue;
                }
                int[] values = new int[np];
                for (int j = 0; j < np; ++j) {
                    values[j] = i++;
                }
                ps.setIndices(values);
            }
            this.initDone = true;
        }
    }

    public ParameterSpace<T> getParameterSpace() {
        return this.parameterSpace;
    }

    @Override
    public void reportResults(OptimizationResult result) {
    }

    @Override
    public void setRngSeed(long rngSeed) {
        this.rng.setSeed(rngSeed);
    }

    public AtomicInteger getCandidateCounter() {
        return this.candidateCounter;
    }

    public SynchronizedRandomGenerator getRng() {
        return this.rng;
    }

    public Map<String, Object> getDataParameters() {
        return this.dataParameters;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public void setParameterSpace(ParameterSpace<T> parameterSpace) {
        this.parameterSpace = parameterSpace;
    }

    public void setCandidateCounter(AtomicInteger candidateCounter) {
        this.candidateCounter = candidateCounter;
    }

    public void setRng(SynchronizedRandomGenerator rng) {
        this.rng = rng;
    }

    public void setDataParameters(Map<String, Object> dataParameters) {
        this.dataParameters = dataParameters;
    }

    public void setInitDone(boolean initDone) {
        this.initDone = initDone;
    }

    public String toString() {
        return "BaseCandidateGenerator(parameterSpace=" + this.getParameterSpace() + ", candidateCounter=" + this.getCandidateCounter() + ", rng=" + this.getRng() + ", dataParameters=" + this.getDataParameters() + ", initDone=" + this.isInitDone() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCandidateGenerator)) {
            return false;
        }
        BaseCandidateGenerator other = (BaseCandidateGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParameterSpace<T> this$parameterSpace = this.getParameterSpace();
        ParameterSpace<T> other$parameterSpace = other.getParameterSpace();
        if (this$parameterSpace == null ? other$parameterSpace != null : !this$parameterSpace.equals(other$parameterSpace)) {
            return false;
        }
        Map<String, Object> this$dataParameters = this.getDataParameters();
        Map<String, Object> other$dataParameters = other.getDataParameters();
        if (this$dataParameters == null ? other$dataParameters != null : !((Object)this$dataParameters).equals(other$dataParameters)) {
            return false;
        }
        return this.isInitDone() == other.isInitDone();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCandidateGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<T> $parameterSpace = this.getParameterSpace();
        result = result * 59 + ($parameterSpace == null ? 43 : $parameterSpace.hashCode());
        Map<String, Object> $dataParameters = this.getDataParameters();
        result = result * 59 + ($dataParameters == null ? 43 : ((Object)$dataParameters).hashCode());
        result = result * 59 + (this.isInitDone() ? 79 : 97);
        return result;
    }
}

