/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.math3.random.RandomAdaptor;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.generator.BaseCandidateGenerator;
import org.deeplearning4j.arbiter.optimize.parameter.discrete.DiscreteParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.integer.IntegerParameterSpace;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"numValuesPerParam", "totalNumCandidates", "order", "candidateCounter", "rng", "candidate"})
public class GridSearchCandidateGenerator
extends BaseCandidateGenerator {
    private static final Logger log = LoggerFactory.getLogger(GridSearchCandidateGenerator.class);
    private final int discretizationCount;
    private final Mode mode;
    private int[] numValuesPerParam;
    private int totalNumCandidates;
    private Queue<Integer> order;

    public GridSearchCandidateGenerator(@JsonProperty(value="parameterSpace") ParameterSpace<?> parameterSpace, @JsonProperty(value="discretizationCount") int discretizationCount, @JsonProperty(value="mode") Mode mode, @JsonProperty(value="dataParameters") Map<String, Object> dataParameters, @JsonProperty(value="initDone") boolean initDone) {
        super(parameterSpace, dataParameters, initDone);
        this.discretizationCount = discretizationCount;
        this.mode = mode;
        this.initialize();
    }

    public GridSearchCandidateGenerator(ParameterSpace<?> parameterSpace, int discretizationCount, Mode mode, Map<String, Object> dataParameters) {
        this(parameterSpace, discretizationCount, mode, dataParameters, false);
    }

    @Override
    protected void initialize() {
        int i;
        super.initialize();
        List<ParameterSpace> leaves = LeafUtils.getUniqueObjects(this.parameterSpace.collectLeaves());
        int nParams = leaves.size();
        this.numValuesPerParam = new int[nParams];
        long searchSize = 1L;
        for (i = 0; i < nParams; ++i) {
            ParameterSpace ps = leaves.get(i);
            if (ps instanceof DiscreteParameterSpace) {
                DiscreteParameterSpace dps = (DiscreteParameterSpace)ps;
                this.numValuesPerParam[i] = dps.numValues();
            } else if (ps instanceof IntegerParameterSpace) {
                IntegerParameterSpace ips = (IntegerParameterSpace)ps;
                int min = ips.getMin();
                int max = ips.getMax();
                this.numValuesPerParam[i] = Math.min(max - min + 1, this.discretizationCount);
            } else {
                this.numValuesPerParam[i] = this.discretizationCount;
            }
            searchSize *= (long)this.numValuesPerParam[i];
        }
        if (searchSize >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid search: cannot process search with " + searchSize + " candidates > Integer.MAX_VALUE");
        }
        this.order = new ConcurrentLinkedQueue<Integer>();
        this.totalNumCandidates = (int)searchSize;
        switch (this.mode) {
            case Sequential: {
                for (i = 0; i < this.totalNumCandidates; ++i) {
                    this.order.add(i);
                }
                break;
            }
            case RandomOrder: {
                ArrayList<Integer> tempList = new ArrayList<Integer>(this.totalNumCandidates);
                for (int i2 = 0; i2 < this.totalNumCandidates; ++i2) {
                    tempList.add(i2);
                }
                Collections.shuffle(tempList, (Random)new RandomAdaptor((RandomGenerator)this.rng));
                this.order.addAll(tempList);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public boolean hasMoreCandidates() {
        return !this.order.isEmpty();
    }

    @Override
    public Candidate getCandidate() {
        int next = this.order.remove();
        double[] values = GridSearchCandidateGenerator.indexToValues(this.numValuesPerParam, next, this.totalNumCandidates);
        Object value = null;
        Exception e = null;
        try {
            value = this.parameterSpace.getValue(values);
        }
        catch (Exception e2) {
            log.warn("Error getting configuration for candidate", (Throwable)e2);
            e = e2;
        }
        return new Candidate<Object>(value, this.candidateCounter.getAndIncrement(), values, (Map<String, Object>)this.dataParameters, e);
    }

    @Override
    public Class<?> getCandidateType() {
        return null;
    }

    public static double[] indexToValues(int[] numValuesPerParam, int candidateIdx, int product) {
        int denom = product;
        int num = candidateIdx;
        int[] index = new int[numValuesPerParam.length];
        for (int i = index.length - 1; i >= 0; --i) {
            index[i] = num / (denom /= numValuesPerParam[i]);
            num %= denom;
        }
        double[] out = new double[numValuesPerParam.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = numValuesPerParam[i] <= 1 ? 0.0 : (double)index[i] / (double)(numValuesPerParam[i] - 1);
        }
        return out;
    }

    @Override
    public String toString() {
        return "GridSearchCandidateGenerator(mode=" + (Object)((Object)this.mode) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridSearchCandidateGenerator)) {
            return false;
        }
        GridSearchCandidateGenerator other = (GridSearchCandidateGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.discretizationCount != other.discretizationCount) {
            return false;
        }
        Mode this$mode = this.mode;
        Mode other$mode = other.mode;
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        if (!Arrays.equals(this.numValuesPerParam, other.numValuesPerParam)) {
            return false;
        }
        return this.totalNumCandidates == other.totalNumCandidates;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GridSearchCandidateGenerator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.discretizationCount;
        Mode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        result = result * 59 + Arrays.hashCode(this.numValuesPerParam);
        result = result * 59 + this.totalNumCandidates;
        return result;
    }

    public static enum Mode {
        Sequential,
        RandomOrder;

    }
}

