/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.generator;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.generator.BaseCandidateGenerator;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"numValuesPerParam", "totalNumCandidates", "order", "candidateCounter", "rng", "candidate"})
public class RandomSearchGenerator
extends BaseCandidateGenerator {
    private static final Logger log = LoggerFactory.getLogger(RandomSearchGenerator.class);

    @JsonCreator
    public RandomSearchGenerator(@JsonProperty(value="parameterSpace") ParameterSpace<?> parameterSpace, @JsonProperty(value="dataParameters") Map<String, Object> dataParameters, @JsonProperty(value="initDone") boolean initDone) {
        super(parameterSpace, dataParameters, initDone);
        this.initialize();
    }

    public RandomSearchGenerator(ParameterSpace<?> parameterSpace, Map<String, Object> dataParameters) {
        this(parameterSpace, dataParameters, false);
    }

    public RandomSearchGenerator(ParameterSpace<?> parameterSpace) {
        this(parameterSpace, (Map<String, Object>)null, false);
    }

    @Override
    public boolean hasMoreCandidates() {
        return true;
    }

    @Override
    public Candidate getCandidate() {
        double[] randomValues = new double[this.parameterSpace.numParameters()];
        for (int i = 0; i < randomValues.length; ++i) {
            randomValues[i] = this.rng.nextDouble();
        }
        Object value = null;
        Exception e = null;
        try {
            value = this.parameterSpace.getValue(randomValues);
        }
        catch (Exception e2) {
            log.warn("Error getting configuration for candidate", (Throwable)e2);
            e = e2;
        }
        return new Candidate<Object>(value, this.candidateCounter.getAndIncrement(), randomValues, (Map<String, Object>)this.dataParameters, e);
    }

    @Override
    public Class<?> getCandidateType() {
        return null;
    }

    @Override
    public String toString() {
        return "RandomSearchGenerator";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomSearchGenerator)) {
            return false;
        }
        RandomSearchGenerator other = (RandomSearchGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RandomSearchGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

