/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.generator.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nd4j.linalg.function.Supplier;

public class SerializedSupplier<T>
implements Serializable,
Supplier<T> {
    private byte[] asBytes;

    public SerializedSupplier(T obj) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            this.asBytes = baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing object - must be serializable", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get() {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.asBytes));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing object", e);
        }
    }
}

