/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;

public class BooleanSpace
implements ParameterSpace<Boolean> {
    private int index = -1;

    @Override
    public Boolean getValue(double[] input) {
        if (this.index == -1) {
            throw new IllegalStateException("Cannot get value: ParameterSpace index has not been set");
        }
        if (input[this.index] <= 0.5) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setIndices(int ... indices) {
        if (indices == null || indices.length != 1) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.index = indices[0];
    }

    public String toString() {
        return "BooleanSpace()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BooleanSpace)) {
            return false;
        }
        BooleanSpace other = (BooleanSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.index == other.index;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BooleanSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index;
        return result;
    }
}

