/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.continuous;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.distribution.DistributionUtils;
import org.deeplearning4j.arbiter.optimize.serde.jackson.RealDistributionDeserializer;
import org.deeplearning4j.arbiter.optimize.serde.jackson.RealDistributionSerializer;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

public class ContinuousParameterSpace
implements ParameterSpace<Double> {
    @JsonSerialize(using=RealDistributionSerializer.class)
    @JsonDeserialize(using=RealDistributionDeserializer.class)
    private RealDistribution distribution;
    private int index = -1;

    public ContinuousParameterSpace(double min, double max) {
        this((RealDistribution)new UniformRealDistribution(min, max));
    }

    public ContinuousParameterSpace(@JsonProperty(value="distribution") RealDistribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public Double getValue(double[] input) {
        if (this.index == -1) {
            throw new IllegalStateException("Cannot get value: ParameterSpace index has not been set");
        }
        return this.distribution.inverseCumulativeProbability(input[this.index]);
    }

    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setIndices(int ... indices) {
        if (indices == null || indices.length != 1) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.index = indices[0];
    }

    public String toString() {
        if (this.distribution instanceof UniformRealDistribution) {
            return "ContinuousParameterSpace(min=" + this.distribution.getSupportLowerBound() + ",max=" + this.distribution.getSupportUpperBound() + ")";
        }
        return "ContinuousParameterSpace(" + this.distribution + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContinuousParameterSpace)) {
            return false;
        }
        ContinuousParameterSpace other = (ContinuousParameterSpace)o;
        if (this.distribution == null ? other.distribution != null : !DistributionUtils.distributionsEqual(this.distribution, other.distribution)) {
            return false;
        }
        return this.index == other.index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.distribution == null ? 43 : this.distribution.getClass().hashCode());
        result = result * 59 + this.index;
        return result;
    }
}

