/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.discrete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.util.ObjectUtils;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

public class DiscreteParameterSpace<P>
implements ParameterSpace<P> {
    @JsonSerialize
    private List<P> values;
    private int index = -1;

    public DiscreteParameterSpace(P ... values) {
        if (values != null) {
            this.values = Arrays.asList(values);
        }
    }

    public DiscreteParameterSpace(Collection<P> values) {
        this.values = new ArrayList<P>(values);
    }

    public int numValues() {
        return this.values.size();
    }

    @Override
    public P getValue(double[] input) {
        if (this.index == -1) {
            throw new IllegalStateException("Cannot get value: ParameterSpace index has not been set");
        }
        if (this.values == null) {
            throw new IllegalStateException("Values are null.");
        }
        int size = this.values.size();
        if (size == 1) {
            return this.values.get(0);
        }
        double width = 1.0 / (double)size;
        int val = (int)(input[this.index] / width);
        return this.values.get(Math.min(val, size - 1));
    }

    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setIndices(int ... indices) {
        if (indices == null || indices.length != 1) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.index = indices[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscreteParameterSpace(");
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            P value = this.values.get(i);
            sb.append(ObjectUtils.valueToString(value));
            sb.append(i == n - 1 ? ")" : ",");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscreteParameterSpace)) {
            return false;
        }
        DiscreteParameterSpace other = (DiscreteParameterSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<P> this$values = this.values;
        List<P> other$values = other.values;
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        return this.index == other.index;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiscreteParameterSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<P> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        result = result * 59 + this.index;
        return result;
    }
}

