/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.integer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.distribution.DistributionUtils;
import org.deeplearning4j.arbiter.optimize.serde.jackson.IntegerDistributionDeserializer;
import org.deeplearning4j.arbiter.optimize.serde.jackson.IntegerDistributionSerializer;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonIgnoreProperties(value={"min", "max"})
public class IntegerParameterSpace
implements ParameterSpace<Integer> {
    @JsonSerialize(using=IntegerDistributionSerializer.class)
    @JsonDeserialize(using=IntegerDistributionDeserializer.class)
    private IntegerDistribution distribution;
    private int index = -1;

    public IntegerParameterSpace(int min, int max) {
        this((IntegerDistribution)new UniformIntegerDistribution(min, max));
    }

    @JsonCreator
    public IntegerParameterSpace(@JsonProperty(value="distribution") IntegerDistribution distribution) {
        this.distribution = distribution;
    }

    public int getMin() {
        return this.distribution.getSupportLowerBound();
    }

    public int getMax() {
        return this.distribution.getSupportUpperBound();
    }

    @Override
    public Integer getValue(double[] input) {
        if (this.index == -1) {
            throw new IllegalStateException("Cannot get value: ParameterSpace index has not been set");
        }
        return this.distribution.inverseCumulativeProbability(input[this.index]);
    }

    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setIndices(int ... indices) {
        if (indices == null || indices.length != 1) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.index = indices[0];
    }

    public String toString() {
        if (this.distribution instanceof UniformIntegerDistribution) {
            return "IntegerParameterSpace(min=" + this.distribution.getSupportLowerBound() + ",max=" + this.distribution.getSupportUpperBound() + ")";
        }
        return "IntegerParameterSpace(" + this.distribution + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerParameterSpace)) {
            return false;
        }
        IntegerParameterSpace other = (IntegerParameterSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.distribution == null ? other.distribution != null : !DistributionUtils.distributionEquals(this.distribution, other.distribution)) {
            return false;
        }
        return this.index == other.index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.distribution == null ? 43 : this.distribution.getClass().hashCode());
        result = result * 59 + this.index;
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegerParameterSpace;
    }

    public IntegerParameterSpace() {
    }
}

