/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.math;

import java.util.List;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.math.Op;

public class MathOp<T extends Number>
extends AbstractParameterSpace<T> {
    private ParameterSpace<T> parameterSpace;
    private Op op;
    private T scalar;

    public MathOp(ParameterSpace<T> parameterSpace, Op op, T scalar) {
        this.parameterSpace = parameterSpace;
        this.op = op;
        this.scalar = scalar;
    }

    @Override
    public T getValue(double[] parameterValues) {
        Number u = (Number)this.parameterSpace.getValue(parameterValues);
        return (T)this.op.doOp(u, this.scalar);
    }

    @Override
    public int numParameters() {
        return this.parameterSpace.numParameters();
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return this.parameterSpace.collectLeaves();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        this.parameterSpace.setIndices(indices);
    }
}

