/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.math;

public enum Op {
    ADD,
    SUB,
    MUL,
    DIV;


    <T extends Number> T doOp(T first, T second) {
        if (first instanceof Integer || first instanceof Long) {
            long result;
            switch (this) {
                case ADD: {
                    result = first.longValue() + second.longValue();
                    break;
                }
                case SUB: {
                    result = first.longValue() - second.longValue();
                    break;
                }
                case MUL: {
                    result = first.longValue() * second.longValue();
                    break;
                }
                case DIV: {
                    result = first.longValue() / second.longValue();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown op: " + (Object)((Object)this));
                }
            }
            if (first instanceof Long) {
                return (T)Long.valueOf(result);
            }
            return (T)Integer.valueOf((int)result);
        }
        if (first instanceof Double || first instanceof Float) {
            double result;
            switch (this) {
                case ADD: {
                    result = first.doubleValue() + second.doubleValue();
                    break;
                }
                case SUB: {
                    result = first.doubleValue() - second.doubleValue();
                    break;
                }
                case MUL: {
                    result = first.doubleValue() * second.doubleValue();
                    break;
                }
                case DIV: {
                    result = first.doubleValue() / second.doubleValue();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown op: " + (Object)((Object)this));
                }
            }
            if (first instanceof Double) {
                return (T)Double.valueOf(result);
            }
            return (T)Float.valueOf((float)result);
        }
        throw new UnsupportedOperationException("Not supported type: only Integer, Long, Double, Float supported here. Got type: " + first.getClass());
    }
}

