/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.parameter.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.math.Op;

public class PairMathOp<T extends Number>
extends AbstractParameterSpace<T> {
    private ParameterSpace<T> first;
    private ParameterSpace<T> second;
    private Op op;

    public PairMathOp(ParameterSpace<T> first, ParameterSpace<T> second, Op op) {
        this.first = first;
        this.second = second;
        this.op = op;
    }

    @Override
    public T getValue(double[] parameterValues) {
        Number f = (Number)this.first.getValue(parameterValues);
        Number s = (Number)this.second.getValue(parameterValues);
        return (T)this.op.doOp(f, s);
    }

    @Override
    public int numParameters() {
        return this.first.numParameters() + this.second.numParameters();
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        ArrayList<ParameterSpace> l = new ArrayList<ParameterSpace>();
        l.addAll(this.first.collectLeaves());
        l.addAll(this.second.collectLeaves());
        return l;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        int n1 = this.first.numParameters();
        int n2 = this.second.numParameters();
        int[] s1 = Arrays.copyOfRange(indices, 0, n1);
        int[] s2 = Arrays.copyOfRange(indices, n1, n1 + n2);
        this.first.setIndices(s1);
        this.second.setIndices(s2);
    }
}

