/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.runner;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.data.DataSource;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition;
import org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration;
import org.deeplearning4j.arbiter.optimize.runner.CandidateInfo;
import org.deeplearning4j.arbiter.optimize.runner.CandidateStatus;
import org.deeplearning4j.arbiter.optimize.runner.IOptimizationRunner;
import org.deeplearning4j.arbiter.optimize.runner.listener.StatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOptimizationRunner
implements IOptimizationRunner {
    private static final Logger log = LoggerFactory.getLogger(BaseOptimizationRunner.class);
    private static final int POLLING_FREQUENCY = 1;
    private static final TimeUnit POLLING_FREQUENCY_UNIT = TimeUnit.SECONDS;
    protected OptimizationConfiguration config;
    protected Queue<Future<OptimizationResult>> queuedFutures = new ConcurrentLinkedQueue<Future<OptimizationResult>>();
    protected BlockingQueue<Future<OptimizationResult>> completedFutures = new LinkedBlockingQueue<Future<OptimizationResult>>();
    protected AtomicInteger totalCandidateCount = new AtomicInteger();
    protected AtomicInteger numCandidatesCompleted = new AtomicInteger();
    protected AtomicInteger numCandidatesFailed = new AtomicInteger();
    protected Double bestScore = null;
    protected Long bestScoreTime = null;
    protected AtomicInteger bestScoreCandidateIndex = new AtomicInteger(-1);
    protected List<ResultReference> allResults = new ArrayList<ResultReference>();
    protected Map<Integer, CandidateInfo> currentStatus = new ConcurrentHashMap<Integer, CandidateInfo>();
    protected ExecutorService futureListenerExecutor;
    protected List<StatusListener> statusListeners = new ArrayList<StatusListener>();

    protected BaseOptimizationRunner(OptimizationConfiguration config) {
        this.config = config;
        if (config.getTerminationConditions() == null || config.getTerminationConditions().size() == 0) {
            throw new IllegalArgumentException("Cannot create BaseOptimizationRunner without TerminationConditions (termination conditions are null or empty)");
        }
    }

    protected void init() {
        this.futureListenerExecutor = Executors.newFixedThreadPool(this.maxConcurrentTasks(), new ThreadFactory(){
            private AtomicLong counter = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("ArbiterOptimizationRunner-" + this.counter.getAndIncrement());
                return t;
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 8[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CandidateInfo processFailedCandidates(Candidate<?> candidate) {
        long time = System.currentTimeMillis();
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)candidate.getException());
        CandidateInfo newStatus = new CandidateInfo(candidate.getIndex(), CandidateStatus.Failed, null, time, time, time, candidate.getFlatParameters(), stackTrace);
        this.currentStatus.put(candidate.getIndex(), newStatus);
        return newStatus;
    }

    private void processReturnedTask(Future<OptimizationResult> future) {
        OptimizationResult result;
        long currentTime = System.currentTimeMillis();
        try {
            result = future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected InterruptedException thrown for task", e);
        }
        catch (ExecutionException e) {
            log.warn("Task failed", (Throwable)e);
            this.numCandidatesFailed.getAndIncrement();
            return;
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        CandidateInfo status = this.currentStatus.get(result.getIndex());
        CandidateInfo newStatus = new CandidateInfo(result.getIndex(), result.getCandidateInfo().getCandidateStatus(), result.getScore(), status.getCreatedTime(), result.getCandidateInfo().getStartTime(), currentTime, status.getFlatParams(), result.getCandidateInfo().getExceptionStackTrace());
        this.currentStatus.put(result.getIndex(), newStatus);
        if (result.getCandidateInfo().getCandidateStatus() == CandidateStatus.Failed) {
            log.info("Task {} failed during execution: {}", (Object)result.getIndex(), (Object)result.getCandidateInfo().getExceptionStackTrace());
            this.numCandidatesFailed.getAndIncrement();
        } else {
            this.config.getCandidateGenerator().reportResults(result);
            Double score = result.getScore();
            log.info("Completed task {}, score = {}", (Object)result.getIndex(), (Object)result.getScore());
            boolean minimize = this.config.getScoreFunction().minimize();
            if (score != null && (this.bestScore == null || minimize && score < this.bestScore || !minimize && score > this.bestScore)) {
                if (this.bestScore == null) {
                    log.info("New best score: {} (first completed model)", (Object)score);
                } else {
                    int idx = result.getIndex();
                    int lastBestIdx = this.bestScoreCandidateIndex.get();
                    log.info("New best score: {}, model {} (prev={}, model {})", new Object[]{score, idx, this.bestScore, lastBestIdx});
                }
                this.bestScore = score;
                this.bestScoreTime = System.currentTimeMillis();
                this.bestScoreCandidateIndex.set(result.getIndex());
            }
            this.numCandidatesCompleted.getAndIncrement();
            ResultReference resultReference = result.getResultReference();
            if (resultReference != null) {
                this.allResults.add(resultReference);
            }
        }
    }

    @Override
    public int numCandidatesTotal() {
        return this.totalCandidateCount.get();
    }

    @Override
    public int numCandidatesCompleted() {
        return this.numCandidatesCompleted.get();
    }

    @Override
    public int numCandidatesFailed() {
        return this.numCandidatesFailed.get();
    }

    @Override
    public int numCandidatesQueued() {
        return this.queuedFutures.size();
    }

    @Override
    public Double bestScore() {
        return this.bestScore;
    }

    @Override
    public Long bestScoreTime() {
        return this.bestScoreTime;
    }

    @Override
    public int bestScoreCandidateIndex() {
        return this.bestScoreCandidateIndex.get();
    }

    @Override
    public List<ResultReference> getResults() {
        return new ArrayList<ResultReference>(this.allResults);
    }

    @Override
    public OptimizationConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void addListeners(StatusListener ... listeners) {
        for (StatusListener l : listeners) {
            if (this.statusListeners.contains(l)) continue;
            this.statusListeners.add(l);
        }
    }

    @Override
    public void removeListeners(StatusListener ... listeners) {
        for (StatusListener l : listeners) {
            if (!this.statusListeners.contains(l)) continue;
            this.statusListeners.remove(l);
        }
    }

    @Override
    public void removeAllListeners() {
        this.statusListeners.clear();
    }

    @Override
    public List<CandidateInfo> getCandidateStatus() {
        ArrayList<CandidateInfo> list = new ArrayList<CandidateInfo>();
        list.addAll(this.currentStatus.values());
        return list;
    }

    private boolean terminate() {
        for (TerminationCondition c : this.config.getTerminationConditions()) {
            if (!c.terminate(this)) continue;
            log.info("BaseOptimizationRunner global termination condition hit: {}", (Object)c);
            return true;
        }
        return false;
    }

    protected abstract int maxConcurrentTasks();

    @Deprecated
    protected abstract ListenableFuture<OptimizationResult> execute(Candidate var1, DataProvider var2, ScoreFunction var3);

    @Deprecated
    protected abstract List<ListenableFuture<OptimizationResult>> execute(List<Candidate> var1, DataProvider var2, ScoreFunction var3);

    protected abstract ListenableFuture<OptimizationResult> execute(Candidate var1, Class<? extends DataSource> var2, Properties var3, ScoreFunction var4);

    protected abstract List<ListenableFuture<OptimizationResult>> execute(List<Candidate> var1, Class<? extends DataSource> var2, Properties var3, ScoreFunction var4);

    private class OnCompletionListener
    implements Runnable {
        private Future<OptimizationResult> future;

        @Override
        public void run() {
            BaseOptimizationRunner.this.completedFutures.add(this.future);
        }

        public OnCompletionListener(Future<OptimizationResult> future) {
            this.future = future;
        }
    }

    private class FutureDetails {
        private final Future<OptimizationResult> future;
        private final long startTime;
        private final int index;

        public FutureDetails(Future<OptimizationResult> future, long startTime, int index) {
            this.future = future;
            this.startTime = startTime;
            this.index = index;
        }

        public Future<OptimizationResult> getFuture() {
            return this.future;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FutureDetails)) {
                return false;
            }
            FutureDetails other = (FutureDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Future<OptimizationResult> this$future = this.getFuture();
            Future<OptimizationResult> other$future = other.getFuture();
            if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            return this.getIndex() == other.getIndex();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FutureDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Future<OptimizationResult> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            result = result * 59 + this.getIndex();
            return result;
        }

        public String toString() {
            return "BaseOptimizationRunner.FutureDetails(future=" + this.getFuture() + ", startTime=" + this.getStartTime() + ", index=" + this.getIndex() + ")";
        }
    }
}

