/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.runner;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.TaskCreator;
import org.deeplearning4j.arbiter.optimize.api.TaskCreatorProvider;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.data.DataSource;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration;
import org.deeplearning4j.arbiter.optimize.runner.BaseOptimizationRunner;

public class LocalOptimizationRunner
extends BaseOptimizationRunner {
    public static final int DEFAULT_MAX_CONCURRENT_TASKS = 1;
    private final int maxConcurrentTasks;
    private TaskCreator taskCreator;
    private ListeningExecutorService executor;
    private long shutdownMaxWaitMS = 172800000L;

    public LocalOptimizationRunner(OptimizationConfiguration config) {
        this(config, null);
    }

    public LocalOptimizationRunner(OptimizationConfiguration config, TaskCreator taskCreator) {
        this(1, config, taskCreator);
    }

    public LocalOptimizationRunner(int maxConcurrentTasks, OptimizationConfiguration config) {
        this(maxConcurrentTasks, config, null);
    }

    public LocalOptimizationRunner(int maxConcurrentTasks, OptimizationConfiguration config, TaskCreator taskCreator) {
        super(config);
        Class<?> psClass;
        if (maxConcurrentTasks <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasks must be > 0 (got: " + maxConcurrentTasks + ")");
        }
        this.maxConcurrentTasks = maxConcurrentTasks;
        if (taskCreator == null && (taskCreator = TaskCreatorProvider.defaultTaskCreatorFor(psClass = config.getCandidateGenerator().getParameterSpace().getClass())) == null) {
            throw new IllegalStateException("No TaskCreator was provided and a default TaskCreator cannot be inferred for ParameterSpace class " + psClass.getName() + ". Please provide a TaskCreator via the LocalOptimizationRunner constructor");
        }
        this.taskCreator = taskCreator;
        ExecutorService exec = Executors.newFixedThreadPool(maxConcurrentTasks, new ThreadFactory(){
            private AtomicLong counter = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("LocalCandidateExecutor-" + this.counter.getAndIncrement());
                return t;
            }
        });
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.init();
    }

    @Override
    protected int maxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    @Override
    protected ListenableFuture<OptimizationResult> execute(Candidate candidate, DataProvider dataProvider, ScoreFunction scoreFunction) {
        return this.execute(Collections.singletonList(candidate), dataProvider, scoreFunction).get(0);
    }

    @Override
    protected List<ListenableFuture<OptimizationResult>> execute(List<Candidate> candidates, DataProvider dataProvider, ScoreFunction scoreFunction) {
        ArrayList<ListenableFuture<OptimizationResult>> list = new ArrayList<ListenableFuture<OptimizationResult>>(candidates.size());
        for (Candidate candidate : candidates) {
            Callable<OptimizationResult> task = this.taskCreator.create(candidate, dataProvider, scoreFunction, this.statusListeners, this);
            list.add((ListenableFuture<OptimizationResult>)this.executor.submit(task));
        }
        return list;
    }

    @Override
    protected ListenableFuture<OptimizationResult> execute(Candidate candidate, Class<? extends DataSource> dataSource, Properties dataSourceProperties, ScoreFunction scoreFunction) {
        return this.execute(Collections.singletonList(candidate), dataSource, dataSourceProperties, scoreFunction).get(0);
    }

    @Override
    protected List<ListenableFuture<OptimizationResult>> execute(List<Candidate> candidates, Class<? extends DataSource> dataSource, Properties dataSourceProperties, ScoreFunction scoreFunction) {
        ArrayList<ListenableFuture<OptimizationResult>> list = new ArrayList<ListenableFuture<OptimizationResult>>(candidates.size());
        for (Candidate candidate : candidates) {
            Callable<OptimizationResult> task = this.taskCreator.create(candidate, dataSource, dataSourceProperties, scoreFunction, this.statusListeners, this);
            list.add((ListenableFuture<OptimizationResult>)this.executor.submit(task));
        }
        return list;
    }

    @Override
    public void shutdown(boolean awaitTermination) {
        if (awaitTermination) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(this.shutdownMaxWaitMS, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.executor.shutdownNow();
        }
    }

    public void setShutdownMaxWaitMS(long shutdownMaxWaitMS) {
        this.shutdownMaxWaitMS = shutdownMaxWaitMS;
    }
}

