/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.serde.jackson;

import java.io.IOException;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;

public class IntegerDistributionDeserializer
extends JsonDeserializer<IntegerDistribution> {
    public IntegerDistribution deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String simpleName;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        switch (simpleName = node.get("distribution").asText()) {
            case "BinomialDistribution": {
                return new BinomialDistribution(node.get("trials").asInt(), node.get("p").asDouble());
            }
            case "GeometricDistribution": {
                return new GeometricDistribution(node.get("p").asDouble());
            }
            case "HypergeometricDistribution": {
                return new HypergeometricDistribution(node.get("populationSize").asInt(), node.get("numberOfSuccesses").asInt(), node.get("sampleSize").asInt());
            }
            case "PascalDistribution": {
                return new PascalDistribution(node.get("r").asInt(), node.get("p").asDouble());
            }
            case "PoissonDistribution": {
                return new PoissonDistribution(node.get("p").asDouble());
            }
            case "UniformIntegerDistribution": {
                return new UniformIntegerDistribution(node.get("lower").asInt(), node.get("upper").asInt());
            }
            case "ZipfDistribution": {
                return new ZipfDistribution(node.get("numElements").asInt(), node.get("exponent").asDouble());
            }
        }
        throw new RuntimeException("Unknown or not supported distribution: " + simpleName);
    }
}

