/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.optimize.serde.jackson;

import java.io.IOException;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.LevyDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.ParetoDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.TriangularDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.deeplearning4j.arbiter.optimize.distribution.LogUniformDistribution;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializerProvider;

public class RealDistributionSerializer
extends JsonSerializer<RealDistribution> {
    public void serialize(RealDistribution d, JsonGenerator j, SerializerProvider serializerProvider) throws IOException {
        Class<?> c = d.getClass();
        String s = c.getSimpleName();
        j.writeStartObject();
        j.writeStringField("distribution", s);
        if (c == BetaDistribution.class) {
            BetaDistribution bd = (BetaDistribution)d;
            j.writeNumberField("alpha", bd.getAlpha());
            j.writeNumberField("beta", bd.getBeta());
        } else if (c == CauchyDistribution.class) {
            CauchyDistribution cd = (CauchyDistribution)d;
            j.writeNumberField("median", cd.getMedian());
            j.writeNumberField("scale", cd.getScale());
        } else if (c == ChiSquaredDistribution.class) {
            ChiSquaredDistribution cd = (ChiSquaredDistribution)d;
            j.writeNumberField("dof", cd.getDegreesOfFreedom());
        } else if (c == ExponentialDistribution.class) {
            ExponentialDistribution ed = (ExponentialDistribution)d;
            j.writeNumberField("mean", ed.getMean());
        } else if (c == FDistribution.class) {
            FDistribution fd = (FDistribution)d;
            j.writeNumberField("numeratorDof", fd.getNumeratorDegreesOfFreedom());
            j.writeNumberField("denominatorDof", fd.getDenominatorDegreesOfFreedom());
        } else if (c == GammaDistribution.class) {
            GammaDistribution gd = (GammaDistribution)d;
            j.writeNumberField("shape", gd.getShape());
            j.writeNumberField("scale", gd.getScale());
        } else if (c == LevyDistribution.class) {
            LevyDistribution ld = (LevyDistribution)d;
            j.writeNumberField("mu", ld.getLocation());
            j.writeNumberField("c", ld.getScale());
        } else if (c == LogNormalDistribution.class) {
            LogNormalDistribution ln = (LogNormalDistribution)d;
            j.writeNumberField("scale", ln.getScale());
            j.writeNumberField("shape", ln.getShape());
        } else if (c == NormalDistribution.class) {
            NormalDistribution nd = (NormalDistribution)d;
            j.writeNumberField("mean", nd.getMean());
            j.writeNumberField("stdev", nd.getStandardDeviation());
        } else if (c == ParetoDistribution.class) {
            ParetoDistribution pd = (ParetoDistribution)d;
            j.writeNumberField("scale", pd.getScale());
            j.writeNumberField("shape", pd.getShape());
        } else if (c == TDistribution.class) {
            TDistribution td = (TDistribution)d;
            j.writeNumberField("dof", td.getDegreesOfFreedom());
        } else if (c == TriangularDistribution.class) {
            TriangularDistribution td = (TriangularDistribution)d;
            j.writeNumberField("a", td.getSupportLowerBound());
            j.writeNumberField("b", td.getMode());
            j.writeNumberField("c", td.getSupportUpperBound());
        } else if (c == UniformRealDistribution.class) {
            UniformRealDistribution u = (UniformRealDistribution)d;
            j.writeNumberField("lower", u.getSupportLowerBound());
            j.writeNumberField("upper", u.getSupportUpperBound());
        } else if (c == WeibullDistribution.class) {
            WeibullDistribution wb = (WeibullDistribution)d;
            j.writeNumberField("alpha", wb.getShape());
            j.writeNumberField("beta", wb.getScale());
        } else if (c == LogUniformDistribution.class) {
            LogUniformDistribution lud = (LogUniformDistribution)d;
            j.writeNumberField("min", lud.getMin());
            j.writeNumberField("max", lud.getMax());
        } else {
            throw new UnsupportedOperationException("Unknown or not supported RealDistribution: " + d.getClass());
        }
        j.writeEndObject();
    }
}

