/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;

public abstract class BaseNetworkSpace<T>
implements ParameterSpace<T> {
    protected ParameterSpace<Boolean> useDropConnect;
    protected ParameterSpace<Integer> iterations;
    protected Long seed;
    protected ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
    protected ParameterSpace<Boolean> regularization;
    protected ParameterSpace<Boolean> schedules;
    protected ParameterSpace<String> activationFunction;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<Double> biasLearningRate;
    protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
    protected ParameterSpace<Double> lrScoreBasedDecay;
    protected ParameterSpace<LearningRatePolicy> learningRateDecayPolicy;
    protected ParameterSpace<Map<Integer, Double>> learningRateSchedule;
    protected ParameterSpace<Double> lrPolicyDecayRate;
    protected ParameterSpace<Double> lrPolicyPower;
    protected ParameterSpace<Double> lrPolicySteps;
    protected ParameterSpace<Integer> maxNumLineSearchIterations;
    protected ParameterSpace<Boolean> miniBatch;
    protected ParameterSpace<Boolean> minimize;
    protected ParameterSpace<StepFunction> stepFunction;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> dropOut;
    protected ParameterSpace<Double> momentum;
    protected ParameterSpace<Map<Integer, Double>> momentumAfter;
    protected ParameterSpace<Updater> updater;
    protected ParameterSpace<Double> epsilon;
    protected ParameterSpace<Double> rho;
    protected ParameterSpace<Double> rmsDecay;
    protected ParameterSpace<Double> adamMeanDecay;
    protected ParameterSpace<Double> adamVarDecay;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected ParameterSpace<int[]> cnnInputSize;
    protected List<LayerConf> layerSpaces = new ArrayList<LayerConf>();
    protected ParameterSpace<Boolean> backprop;
    protected ParameterSpace<Boolean> pretrain;
    protected ParameterSpace<BackpropType> backpropType;
    protected ParameterSpace<Integer> tbpttFwdLength;
    protected ParameterSpace<Integer> tbpttBwdLength;
    protected int numEpochs = 1;

    protected BaseNetworkSpace(Builder builder) {
        this.useDropConnect = builder.useDropConnect;
        this.iterations = builder.iterations;
        this.seed = builder.seed;
        this.optimizationAlgo = builder.optimizationAlgo;
        this.regularization = builder.regularization;
        this.schedules = builder.schedules;
        this.activationFunction = builder.activationFunction;
        this.biasInit = builder.biasInit;
        this.weightInit = builder.weightInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateAfter = builder.learningRateAfter;
        this.lrScoreBasedDecay = builder.lrScoreBasedDecay;
        this.learningRateDecayPolicy = builder.learningRateDecayPolicy;
        this.learningRateSchedule = builder.learningRateSchedule;
        this.lrPolicyDecayRate = builder.lrPolicyDecayRate;
        this.lrPolicyPower = builder.lrPolicyPower;
        this.lrPolicySteps = builder.lrPolicySteps;
        this.maxNumLineSearchIterations = builder.maxNumLineSearchIterations;
        this.miniBatch = builder.miniBatch;
        this.minimize = builder.minimize;
        this.stepFunction = builder.stepFunction;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.dropOut = builder.dropOut;
        this.momentum = builder.momentum;
        this.momentumAfter = builder.momentumAfter;
        this.updater = builder.updater;
        this.epsilon = builder.epsilon;
        this.rho = builder.rho;
        this.rmsDecay = builder.rmsDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.backprop = builder.backprop;
        this.pretrain = builder.pretrain;
        this.backpropType = builder.backpropType;
        this.tbpttFwdLength = builder.tbpttFwdLength;
        this.tbpttBwdLength = builder.tbpttBwdLength;
        this.cnnInputSize = builder.cnnInputSize;
        this.numEpochs = builder.numEpochs;
    }

    protected NeuralNetConfiguration.Builder randomGlobalConf(double[] values) {
        NeuralNetConfiguration.Builder builder = new NeuralNetConfiguration.Builder();
        if (this.useDropConnect != null) {
            builder.useDropConnect(((Boolean)this.useDropConnect.getValue(values)).booleanValue());
        }
        if (this.iterations != null) {
            builder.iterations(((Integer)this.iterations.getValue(values)).intValue());
        }
        if (this.seed != null) {
            builder.seed(this.seed.longValue());
        }
        if (this.optimizationAlgo != null) {
            builder.optimizationAlgo((OptimizationAlgorithm)this.optimizationAlgo.getValue(values));
        }
        if (this.regularization != null) {
            builder.regularization(((Boolean)this.regularization.getValue(values)).booleanValue());
        }
        if (this.activationFunction != null) {
            builder.activation((String)this.activationFunction.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.learningRate != null) {
            builder.learningRate(((Double)this.learningRate.getValue(values)).doubleValue());
        }
        if (this.biasLearningRate != null) {
            builder.biasLearningRate(((Double)this.biasLearningRate.getValue(values)).doubleValue());
        }
        if (this.learningRateAfter != null) {
            builder.learningRateSchedule((Map)this.learningRateAfter.getValue(values));
        }
        if (this.lrScoreBasedDecay != null) {
            builder.learningRateScoreBasedDecayRate(((Double)this.lrScoreBasedDecay.getValue(values)).doubleValue());
        }
        if (this.learningRateDecayPolicy != null) {
            builder.learningRateDecayPolicy((LearningRatePolicy)this.learningRateDecayPolicy.getValue(values));
        }
        if (this.learningRateSchedule != null) {
            builder.learningRateSchedule((Map)this.learningRateSchedule.getValue(values));
        }
        if (this.lrPolicyDecayRate != null) {
            builder.lrPolicyDecayRate(((Double)this.lrPolicyDecayRate.getValue(values)).doubleValue());
        }
        if (this.lrPolicyPower != null) {
            builder.lrPolicyPower(((Double)this.lrPolicyPower.getValue(values)).doubleValue());
        }
        if (this.lrPolicySteps != null) {
            builder.lrPolicySteps(((Double)this.lrPolicySteps.getValue(values)).doubleValue());
        }
        if (this.maxNumLineSearchIterations != null) {
            builder.maxNumLineSearchIterations(((Integer)this.maxNumLineSearchIterations.getValue(values)).intValue());
        }
        if (this.miniBatch != null) {
            builder.miniBatch(((Boolean)this.miniBatch.getValue(values)).booleanValue());
        }
        if (this.minimize != null) {
            builder.minimize(((Boolean)this.minimize.getValue(values)).booleanValue());
        }
        if (this.stepFunction != null) {
            builder.stepFunction((StepFunction)this.stepFunction.getValue(values));
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.dropOut != null) {
            builder.dropOut(((Double)this.dropOut.getValue(values)).doubleValue());
        }
        if (this.momentum != null) {
            builder.momentum(((Double)this.momentum.getValue(values)).doubleValue());
        }
        if (this.momentumAfter != null) {
            builder.momentumAfter((Map)this.momentumAfter.getValue(values));
        }
        if (this.updater != null) {
            builder.updater((Updater)this.updater.getValue(values));
        }
        if (this.epsilon != null) {
            builder.epsilon(((Double)this.epsilon.getValue(values)).doubleValue());
        }
        if (this.rho != null) {
            builder.rho(((Double)this.rho.getValue(values)).doubleValue());
        }
        if (this.rmsDecay != null) {
            builder.rmsDecay(((Double)this.rmsDecay.getValue(values)).doubleValue());
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
        if (this.adamMeanDecay != null) {
            builder.adamMeanDecay(((Double)this.adamMeanDecay.getValue(values)).doubleValue());
        }
        if (this.adamVarDecay != null) {
            builder.adamVarDecay(((Double)this.adamVarDecay.getValue(values)).doubleValue());
        }
        return builder;
    }

    public List<ParameterSpace> collectLeaves() {
        ArrayList<ParameterSpace> list = new ArrayList<ParameterSpace>();
        if (this.useDropConnect != null) {
            list.addAll(this.useDropConnect.collectLeaves());
        }
        if (this.iterations != null) {
            list.addAll(this.iterations.collectLeaves());
        }
        if (this.optimizationAlgo != null) {
            list.addAll(this.optimizationAlgo.collectLeaves());
        }
        if (this.regularization != null) {
            list.addAll(this.regularization.collectLeaves());
        }
        if (this.schedules != null) {
            list.addAll(this.schedules.collectLeaves());
        }
        if (this.activationFunction != null) {
            list.addAll(this.activationFunction.collectLeaves());
        }
        if (this.biasInit != null) {
            list.addAll(this.biasInit.collectLeaves());
        }
        if (this.weightInit != null) {
            list.addAll(this.weightInit.collectLeaves());
        }
        if (this.dist != null) {
            list.addAll(this.dist.collectLeaves());
        }
        if (this.learningRate != null) {
            list.addAll(this.learningRate.collectLeaves());
        }
        if (this.biasLearningRate != null) {
            list.addAll(this.biasLearningRate.collectLeaves());
        }
        if (this.learningRateAfter != null) {
            list.addAll(this.learningRateAfter.collectLeaves());
        }
        if (this.lrScoreBasedDecay != null) {
            list.addAll(this.lrScoreBasedDecay.collectLeaves());
        }
        if (this.learningRateDecayPolicy != null) {
            list.addAll(this.learningRateDecayPolicy.collectLeaves());
        }
        if (this.learningRateSchedule != null) {
            list.addAll(this.learningRateSchedule.collectLeaves());
        }
        if (this.lrPolicyDecayRate != null) {
            list.addAll(this.lrPolicyDecayRate.collectLeaves());
        }
        if (this.lrPolicyPower != null) {
            list.addAll(this.lrPolicyPower.collectLeaves());
        }
        if (this.lrPolicySteps != null) {
            list.addAll(this.lrPolicySteps.collectLeaves());
        }
        if (this.maxNumLineSearchIterations != null) {
            list.addAll(this.maxNumLineSearchIterations.collectLeaves());
        }
        if (this.miniBatch != null) {
            list.addAll(this.miniBatch.collectLeaves());
        }
        if (this.minimize != null) {
            list.addAll(this.minimize.collectLeaves());
        }
        if (this.stepFunction != null) {
            list.addAll(this.minimize.collectLeaves());
        }
        if (this.l1 != null) {
            list.addAll(this.l1.collectLeaves());
        }
        if (this.l2 != null) {
            list.addAll(this.l2.collectLeaves());
        }
        if (this.dropOut != null) {
            list.addAll(this.dropOut.collectLeaves());
        }
        if (this.momentum != null) {
            list.addAll(this.momentum.collectLeaves());
        }
        if (this.momentumAfter != null) {
            list.addAll(this.momentumAfter.collectLeaves());
        }
        if (this.updater != null) {
            list.addAll(this.updater.collectLeaves());
        }
        if (this.epsilon != null) {
            list.addAll(this.epsilon.collectLeaves());
        }
        if (this.rho != null) {
            list.addAll(this.rho.collectLeaves());
        }
        if (this.rmsDecay != null) {
            list.addAll(this.rmsDecay.collectLeaves());
        }
        if (this.gradientNormalization != null) {
            list.addAll(this.gradientNormalization.collectLeaves());
        }
        if (this.gradientNormalizationThreshold != null) {
            list.addAll(this.gradientNormalizationThreshold.collectLeaves());
        }
        if (this.cnnInputSize != null) {
            list.addAll(this.cnnInputSize.collectLeaves());
        }
        if (this.adamMeanDecay != null) {
            list.addAll(this.adamMeanDecay.collectLeaves());
        }
        if (this.adamVarDecay != null) {
            list.addAll(this.adamVarDecay.collectLeaves());
        }
        if (this.backprop != null) {
            list.add(this.backprop);
        }
        if (this.pretrain != null) {
            list.add(this.pretrain);
        }
        if (this.backpropType != null) {
            list.add(this.backpropType);
        }
        if (this.tbpttBwdLength != null) {
            list.add(this.tbpttBwdLength);
        }
        if (this.tbpttFwdLength != null) {
            list.add(this.tbpttFwdLength);
        }
        return list;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non leaf");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.useDropConnect != null) {
            sb.append("useDropConnect: ").append(this.useDropConnect).append("\n");
        }
        if (this.iterations != null) {
            sb.append("iterations: ").append(this.iterations).append("\n");
        }
        if (this.seed != null) {
            sb.append("seed: ").append(this.seed).append("\n");
        }
        if (this.optimizationAlgo != null) {
            sb.append("optimizationAlgo: ").append(this.optimizationAlgo).append("\n");
        }
        if (this.regularization != null) {
            sb.append("regularization: ").append(this.regularization).append("\n");
        }
        if (this.schedules != null) {
            sb.append("schedules: ").append(this.schedules).append("\n");
        }
        if (this.activationFunction != null) {
            sb.append("activationFunction: ").append(this.activationFunction).append("\n");
        }
        if (this.weightInit != null) {
            sb.append("weightInit: ").append(this.weightInit).append("\n");
        }
        if (this.dist != null) {
            sb.append("dist: ").append(this.dist).append("\n");
        }
        if (this.learningRate != null) {
            sb.append("learningRate: ").append(this.learningRate).append("\n");
        }
        if (this.biasLearningRate != null) {
            sb.append("biasLearningRate: ").append(this.biasLearningRate).append("\n");
        }
        if (this.learningRateAfter != null) {
            sb.append("learningRateAfter: ").append(this.learningRateAfter).append("\n");
        }
        if (this.lrScoreBasedDecay != null) {
            sb.append("lrScoreBasedDecay: ").append(this.lrScoreBasedDecay).append("\n");
        }
        if (this.learningRateDecayPolicy != null) {
            sb.append("learningRateDecayPolicy: ").append(this.learningRateDecayPolicy).append("\n");
        }
        if (this.learningRateSchedule != null) {
            sb.append("learningRateSchedule: ").append(this.learningRateSchedule).append("\n");
        }
        if (this.lrPolicyDecayRate != null) {
            sb.append("lrPolicyDecayRate: ").append(this.lrPolicyDecayRate).append("\n");
        }
        if (this.lrPolicyPower != null) {
            sb.append("lrPolicyPower: ").append(this.lrPolicyPower).append("\n");
        }
        if (this.lrPolicySteps != null) {
            sb.append("lrPolicySteps: ").append(this.lrPolicySteps).append("\n");
        }
        if (this.maxNumLineSearchIterations != null) {
            sb.append("maxNumLineSearchIterations: ").append(this.maxNumLineSearchIterations).append("\n");
        }
        if (this.miniBatch != null) {
            sb.append("miniBatch: ").append(this.miniBatch).append("\n");
        }
        if (this.minimize != null) {
            sb.append("minimize: ").append(this.minimize).append("\n");
        }
        if (this.stepFunction != null) {
            sb.append("stepFunction: ").append(this.stepFunction).append("\n");
        }
        if (this.l1 != null) {
            sb.append("l1: ").append(this.l1).append("\n");
        }
        if (this.l2 != null) {
            sb.append("l2: ").append(this.l2).append("\n");
        }
        if (this.dropOut != null) {
            sb.append("dropOut: ").append(this.dropOut).append("\n");
        }
        if (this.momentum != null) {
            sb.append("momentum: ").append(this.momentum).append("\n");
        }
        if (this.momentumAfter != null) {
            sb.append("momentumAfter: ").append(this.momentumAfter).append("\n");
        }
        if (this.updater != null) {
            sb.append("updater: ").append(this.updater).append("\n");
        }
        if (this.epsilon != null) {
            sb.append("epsilon: ").append(this.epsilon).append("\n");
        }
        if (this.rho != null) {
            sb.append("rho: ").append(this.rho).append("\n");
        }
        if (this.rmsDecay != null) {
            sb.append("rmsDecay: ").append(this.rmsDecay).append("\n");
        }
        if (this.gradientNormalization != null) {
            sb.append("gradientNormalization: ").append(this.gradientNormalization).append("\n");
        }
        if (this.gradientNormalizationThreshold != null) {
            sb.append("gradientNormalizationThreshold: ").append(this.gradientNormalizationThreshold).append("\n");
        }
        if (this.backprop != null) {
            sb.append("backprop: ").append(this.backprop).append("\n");
        }
        if (this.pretrain != null) {
            sb.append("pretrain: ").append(this.pretrain).append("\n");
        }
        if (this.backpropType != null) {
            sb.append("backpropType: ").append(this.backpropType).append("\n");
        }
        if (this.tbpttFwdLength != null) {
            sb.append("tbpttFwdLength: ").append(this.tbpttFwdLength).append("\n");
        }
        if (this.tbpttBwdLength != null) {
            sb.append("tbpttBwdLength: ").append(this.tbpttBwdLength).append("\n");
        }
        if (this.cnnInputSize != null) {
            sb.append("cnnInputSize: ").append(this.cnnInputSize).append("\n");
        }
        if (this.adamMeanDecay != null) {
            sb.append("adamMeanDecay: ").append(this.adamMeanDecay).append("\n");
        }
        if (this.adamVarDecay != null) {
            sb.append("adamVarDecay: ").append(this.adamVarDecay).append("\n");
        }
        int i = 0;
        for (LayerConf conf : this.layerSpaces) {
            sb.append("Layer config ").append(i++).append(": (Number layers:").append(conf.numLayers).append(", duplicate: ").append(conf.duplicateConfig).append("), ").append(conf.layerSpace.toString()).append("\n");
        }
        return sb.toString();
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private ParameterSpace<String> activationFunction;
        private ParameterSpace<WeightInit> weightInit;
        private ParameterSpace<Double> biasInit;
        private ParameterSpace<Boolean> useDropConnect;
        private ParameterSpace<Integer> iterations;
        private Long seed;
        private ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
        private ParameterSpace<Boolean> regularization;
        private ParameterSpace<Boolean> schedules;
        private ParameterSpace<Distribution> dist;
        private ParameterSpace<Double> learningRate;
        private ParameterSpace<Double> biasLearningRate;
        private ParameterSpace<Map<Integer, Double>> learningRateAfter;
        private ParameterSpace<Double> lrScoreBasedDecay;
        private ParameterSpace<LearningRatePolicy> learningRateDecayPolicy;
        private ParameterSpace<Map<Integer, Double>> learningRateSchedule;
        private ParameterSpace<Double> lrPolicyDecayRate;
        private ParameterSpace<Double> lrPolicyPower;
        private ParameterSpace<Double> lrPolicySteps;
        private ParameterSpace<Integer> maxNumLineSearchIterations;
        private ParameterSpace<Boolean> miniBatch;
        private ParameterSpace<Boolean> minimize;
        private ParameterSpace<StepFunction> stepFunction;
        private ParameterSpace<Double> l1;
        private ParameterSpace<Double> l2;
        private ParameterSpace<Double> dropOut;
        private ParameterSpace<Double> momentum;
        private ParameterSpace<Map<Integer, Double>> momentumAfter;
        private ParameterSpace<Updater> updater;
        private ParameterSpace<Double> epsilon;
        private ParameterSpace<Double> rho;
        private ParameterSpace<Double> rmsDecay;
        private ParameterSpace<GradientNormalization> gradientNormalization;
        private ParameterSpace<Double> gradientNormalizationThreshold;
        private ParameterSpace<int[]> cnnInputSize;
        private ParameterSpace<Double> adamMeanDecay;
        private ParameterSpace<Double> adamVarDecay;
        private ParameterSpace<Boolean> backprop;
        private ParameterSpace<Boolean> pretrain;
        private ParameterSpace<BackpropType> backpropType;
        private ParameterSpace<Integer> tbpttFwdLength;
        private ParameterSpace<Integer> tbpttBwdLength;
        private EarlyStoppingConfiguration earlyStoppingConfiguration;
        private int numEpochs = 1;

        protected Builder() {
        }

        public T useDropConnect(boolean useDropConnect) {
            return this.useDropConnect((ParameterSpace<Boolean>)new FixedValue((Object)useDropConnect));
        }

        public T useDropConnect(ParameterSpace<Boolean> parameterSpace) {
            this.useDropConnect = parameterSpace;
            return (T)this;
        }

        public T iterations(int iterations) {
            return this.iterations((ParameterSpace<Integer>)new FixedValue((Object)iterations));
        }

        public T iterations(ParameterSpace<Integer> parameterSpace) {
            this.iterations = parameterSpace;
            return (T)this;
        }

        public T seed(long seed) {
            this.seed = seed;
            return (T)this;
        }

        public T optimizationAlgo(OptimizationAlgorithm optimizationAlgorithm) {
            return this.optimizationAlgo((ParameterSpace<OptimizationAlgorithm>)new FixedValue((Object)optimizationAlgorithm));
        }

        public T optimizationAlgo(ParameterSpace<OptimizationAlgorithm> parameterSpace) {
            this.optimizationAlgo = parameterSpace;
            return (T)this;
        }

        public T regularization(boolean useRegularization) {
            return this.regularization((ParameterSpace<Boolean>)new FixedValue((Object)useRegularization));
        }

        public T regularization(ParameterSpace<Boolean> parameterSpace) {
            this.regularization = parameterSpace;
            return (T)this;
        }

        public T schedules(boolean schedules) {
            return this.schedules((ParameterSpace<Boolean>)new FixedValue((Object)schedules));
        }

        public T schedules(ParameterSpace<Boolean> schedules) {
            this.schedules = schedules;
            return (T)this;
        }

        public T activation(String activationFunction) {
            return this.activation((ParameterSpace<String>)new FixedValue((Object)activationFunction));
        }

        public T activation(ParameterSpace<String> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            return this.learningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T learningRate(ParameterSpace<Double> learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double learningRate) {
            return this.biasLearningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T biasLearningRate(ParameterSpace<Double> biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateAfter(Map<Integer, Double> learningRateAfter) {
            return this.learningRateAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateAfter));
        }

        public T learningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return (T)this;
        }

        public T learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            return this.learningRateScoreBasedDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrScoreBasedDecay));
        }

        public T learningRateScoreBasedDecayRate(ParameterSpace<Double> lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return (T)this;
        }

        public T learningRateDecayPolicy(LearningRatePolicy learningRatePolicy) {
            return this.learningRateDecayPolicy((ParameterSpace<LearningRatePolicy>)new FixedValue((Object)learningRatePolicy));
        }

        public T learningRateDecayPolicy(ParameterSpace<LearningRatePolicy> learningRateDecayPolicy) {
            this.learningRateDecayPolicy = learningRateDecayPolicy;
            return (T)this;
        }

        public T learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            return this.learningRateSchedule((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateSchedule));
        }

        public T learningRateSchedule(ParameterSpace<Map<Integer, Double>> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return (T)this;
        }

        public T lrPolicyDecayRate(double lrPolicyDecayRate) {
            return this.lrPolicyDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrPolicyDecayRate));
        }

        public T lrPolicyDecayRate(ParameterSpace<Double> lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return (T)this;
        }

        public T lrPolicyPower(double lrPolicyPower) {
            return this.lrPolicyPower((ParameterSpace<Double>)new FixedValue((Object)lrPolicyPower));
        }

        public T lrPolicyPower(ParameterSpace<Double> lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return (T)this;
        }

        public T lrPolicySteps(double lrPolicySteps) {
            return this.lrPolicySteps((ParameterSpace<Double>)new FixedValue((Object)lrPolicySteps));
        }

        public T lrPolicySteps(ParameterSpace<Double> lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return (T)this;
        }

        public T maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            return this.maxNumLineSearchIterations((ParameterSpace<Integer>)new FixedValue((Object)maxNumLineSearchIterations));
        }

        public T maxNumLineSearchIterations(ParameterSpace<Integer> maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return (T)this;
        }

        public T miniBatch(boolean minibatch) {
            return this.miniBatch((ParameterSpace<Boolean>)new FixedValue((Object)minibatch));
        }

        public T miniBatch(ParameterSpace<Boolean> miniBatch) {
            this.miniBatch = miniBatch;
            return (T)this;
        }

        public T minimize(boolean minimize) {
            return this.minimize((ParameterSpace<Boolean>)new FixedValue((Object)minimize));
        }

        public T minimize(ParameterSpace<Boolean> minimize) {
            this.minimize = minimize;
            return (T)this;
        }

        public T stepFunction(StepFunction stepFunction) {
            return this.stepFunction((ParameterSpace<StepFunction>)new FixedValue((Object)stepFunction));
        }

        public T stepFunction(ParameterSpace<StepFunction> stepFunction) {
            this.stepFunction = stepFunction;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            return this.dropOut((ParameterSpace<Double>)new FixedValue((Object)dropOut));
        }

        public T dropOut(ParameterSpace<Double> dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T momentum(double momentum) {
            return this.momentum((ParameterSpace<Double>)new FixedValue((Object)momentum));
        }

        public T momentum(ParameterSpace<Double> momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            return this.momentumAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(momentumAfter));
        }

        public T momentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            return this.updater((ParameterSpace<Updater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<Updater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T epsilon(double epsilon) {
            return this.epsilon((ParameterSpace<Double>)new FixedValue((Object)epsilon));
        }

        public T epsilon(ParameterSpace<Double> epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        public T rho(double rho) {
            return this.rho((ParameterSpace<Double>)new FixedValue((Object)rho));
        }

        public T rho(ParameterSpace<Double> rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            return this.rmsDecay((ParameterSpace<Double>)new FixedValue((Object)rmsDecay));
        }

        public T rmsDecay(ParameterSpace<Double> rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }

        public T backprop(boolean backprop) {
            return this.backprop((ParameterSpace<Boolean>)new FixedValue((Object)backprop));
        }

        public T backprop(ParameterSpace<Boolean> backprop) {
            this.backprop = backprop;
            return (T)this;
        }

        public T pretrain(boolean pretrain) {
            return this.pretrain((ParameterSpace<Boolean>)new FixedValue((Object)pretrain));
        }

        public T pretrain(ParameterSpace<Boolean> pretrain) {
            this.pretrain = pretrain;
            return (T)this;
        }

        public T backpropType(BackpropType backpropType) {
            return this.backpropType((ParameterSpace<BackpropType>)new FixedValue((Object)backpropType));
        }

        public T backpropType(ParameterSpace<BackpropType> backpropType) {
            this.backpropType = backpropType;
            return (T)this;
        }

        public T tbpttFwdLength(int tbpttFwdLength) {
            return this.tbpttFwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttFwdLength));
        }

        public T tbpttFwdLength(ParameterSpace<Integer> tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return (T)this;
        }

        public T tbpttBwdLength(int tbpttBwdLength) {
            return this.tbpttBwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttBwdLength));
        }

        public T tbpttBwdLength(ParameterSpace<Integer> tbpttBwdLength) {
            this.tbpttBwdLength = tbpttBwdLength;
            return (T)this;
        }

        public T numEpochs(int numEpochs) {
            this.numEpochs = numEpochs;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            return this.biasInit((ParameterSpace<Double>)new FixedValue((Object)biasInit));
        }

        public T biasInit(ParameterSpace<Double> biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            return this.adamMeanDecay((ParameterSpace<Double>)new FixedValue((Object)adamMeanDecay));
        }

        public T adamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            return this.adamVarDecay((ParameterSpace<Double>)new FixedValue((Object)adamVarDecay));
        }

        public T adamVarDecay(ParameterSpace<Double> adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public abstract <E extends BaseNetworkSpace> E build();
    }

    private static class LayerConf {
        private final LayerSpace<?> layerSpace;
        private final ParameterSpace<Integer> numLayers;
        private final boolean duplicateConfig;

        @ConstructorProperties(value={"layerSpace", "numLayers", "duplicateConfig"})
        public LayerConf(LayerSpace<?> layerSpace, ParameterSpace<Integer> numLayers, boolean duplicateConfig) {
            this.layerSpace = layerSpace;
            this.numLayers = numLayers;
            this.duplicateConfig = duplicateConfig;
        }
    }
}

